//
//  HWMAttendeeManager.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2021/8/24.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMAttendeeManager.h"

@implementation HWMAttendeeManager

+ (void)logAttendees:(NSArray <HWMAttendeeInfo *> *)attendees {
    NSMutableString *itemsString = [[NSMutableString alloc] init];
    [attendees enumerateObjectsUsingBlock:^(HWMAttendeeInfo * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        [itemsString appendFormat:@"第%ld个与会者\n", idx];
        [itemsString appendFormat:@"昵称：%@\n", obj.name];
        [itemsString appendFormat:@"中文昵称：%@\n", obj.aliasCN];
        [itemsString appendFormat:@"英文昵称：%@\n", obj.aliasEN];
        [itemsString appendFormat:@"账号：%@\n", obj.accountId];
        [itemsString appendFormat:@"三方账号：%@\n", obj.thirdUserId];
        [itemsString appendFormat:@"会议状态：%@\n", [self getStateStr:obj.state]];
        [itemsString appendFormat:@"orgid：%@\n", obj.orgId];
        [itemsString appendFormat:@"是否匿名：%@\n", obj.isAnonymous ? @"是" : @"否"];
        [itemsString appendFormat:@"会议中角色：%@\n", [self getRoleStr:obj.role]];
        [itemsString appendFormat:@"number：%@\n", obj.number];
    }];
    [HWMConsoleManager shareInstance].console = itemsString;
}

+ (NSString *)getStateStr:(HWMAttendeeState)state {
    switch (state) {
        case HWMAttendeeStateInConf:
            return @"会议中";
        case HWMAttendeeStateCalling:
            return @"正在呼叫";
        case HWMAttendeeStateJoining:
            return @"正在加入会议";
        case HWMAttendeeStateLeaved:
            return @"已经离开";
        case HWMAttendeeStateNoExist:
            return @"用户不存在";
        case HWMAttendeeStateBusy:
            return @"被叫用户忙";
        case HWMAttendeeStateNoAnswer:
            return @"用户无应答";
        case HWMAttendeeStateReject:
            return @"用户拒绝接听";
        case HWMAttendeeStateFailed:
            return @"呼叫失败";
        default:
            return @"未知";
    }
}

+ (NSString *)getRoleStr:(HWMConfRoleType)type {
    switch (type) {
        case HWMConfRoleTypeAttendee:
            return @"与会者";
        case HWMConfRoleTypeChairman:
            return @"主席";
        case HWMConfRoleTypeAudience:
            return @"观众";
        case HWMConfRoleTypeCohost:
            return @"联席主席";
        default:
            return @"";
    }
}


@end
