//
//  HWMContactInfoModel.h
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/12/8.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <HWMUISDK/HWMUISDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface HWMContactInfoModel : NSObject

/// （选填）账号、密码场景情况下，必填号码 ； appid情况下 选填， 账号必填
 @property (nonatomic, copy) NSString *number;

///（必填)与会者名称
@property (nonatomic, copy) NSString *name;

/// 会中显示的与会者名称 中文昵称
@property (nonatomic, copy) NSString *aliasCN;

/// 会中显示的与会者名称 英文昵称
@property (nonatomic, copy) NSString *aliasEN;

/// 用户登录帐号 若为用户名/密*码登录场景 必填
@property (nonatomic, copy) NSString *accountId;

/// 第三方用户帐号 AppID鉴权方式下 必填
@property (nonatomic, copy) NSString *thirdUserId;

/// 可选，电子邮箱地址
@property (nonatomic, copy) NSString *email;

/// 可选，短信通知手机号码
@property (nonatomic, copy) NSString *sms;

/// 可选，是否闭音
@property (nonatomic, assign) BOOL mute;

///  可选(主动创建会议者，传递主持人，其他传递普通与会者） 会议成员角色
@property (nonatomic, assign) HWMConfRoleType  role;

/// APPID 登录场景下的 APPID，只读
@property (nonatomic, copy, readonly) NSString *appId;

/// 可选，企业id
@property (nonatomic, copy) NSString *corpId;

@end

NS_ASSUME_NONNULL_END
