//
//  HWMConfTypeSelectCell.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/28.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMConfTypeSelectCell.h"

@interface HWMConfTypeSelectCell ()

/// 音频
@property (nonatomic, strong) NSButton *voiceBtn;
/// 视频
@property (nonatomic, strong) NSButton *vedioBtn;

@end

@implementation HWMConfTypeSelectCell

+ (instancetype)initConfTypeSelectCell:(NSTableView *)tableView ower:(id)ower {
    HWMConfTypeSelectCell *cell = [tableView makeViewWithIdentifier:NSStringFromClass([HWMConfTypeSelectCell class]) owner:ower];
    if (cell == nil) {
        cell = [[HWMConfTypeSelectCell alloc] initWithFrame:NSZeroRect];
        cell.identifier = NSStringFromClass([HWMConfTypeSelectCell class]);
    }
    
    return cell;
}

- (instancetype)initWithFrame:(NSRect)frameRect {
    if (self = [super initWithFrame:frameRect]) {
        self.wantsLayer = YES;
        self.layer.backgroundColor = [NSColor whiteColor].CGColor;
        [self setupUI];
    }
    return self;
}

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];

    // Drawing code here.
}

#pragma mark - UI
- (void)setupUI {
    NSArray *titles = @[@"音频", @"视频"];
    NSMutableArray *btnArr = [NSMutableArray array];
    for (NSInteger i = 0; i < titles.count; i++) {
        NSButton *button = [[NSButton alloc] init];
        button.bordered = NO;
        button.font = [NSFont systemFontOfSize:12];
        button.bezelStyle = NSBezelStyleRegularSquare;
        button.state = i ? NSControlStateValueOff : NSControlStateValueOn;
        [button setButtonType:NSButtonTypeRadio];
        [button setTitle:titles[i]];
        button.target = self;
        button.action = @selector(confBtnClick:);
        button.tag = i;
        if (i == 0) {
            self.voiceBtn = button;
        }else {
            self.vedioBtn = button;
        }
        [btnArr addObject:button];
        [self addSubview:button];
    }
    [btnArr mas_distributeViewsAlongAxis:MASAxisTypeHorizontal withFixedSpacing:10 leadSpacing:120 tailSpacing:300];
}

#pragma mark - Setter

- (void)setConfType:(NSInteger)confType {
    _confType = confType;
    if (confType == 0) {
        self.voiceBtn.state = NSControlStateValueOn;
        self.vedioBtn.state = NSControlStateValueOff;
    }else {
        self.voiceBtn.state = NSControlStateValueOff;
        self.vedioBtn.state = NSControlStateValueOn;
    }
}

#pragma mark - Event
- (void)confBtnClick:(NSButton *)sender {
    if (self.delegate && [self.delegate respondsToSelector:@selector(selectedConfType:)]) {
        [self.delegate selectedConfType:sender.tag];
    }
}

@end
