//
//  HWMJoinConfLimitCell.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/11/3.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMJoinConfLimitCell.h"

@interface HWMJoinConfLimitCell ()
/// 标题
@property (nonatomic, strong) NSTextField *titleLabel;
/// 范围
@property (nonatomic, strong) NSButton *limitLabel;

@end

@implementation HWMJoinConfLimitCell

+ (instancetype)joinConfLimitCell:(NSTableView *)tableView ower:(id)ower {
    HWMJoinConfLimitCell *cell = [tableView makeViewWithIdentifier:NSStringFromClass([HWMJoinConfLimitCell class]) owner:ower];
    if (!cell) {
        cell = [[HWMJoinConfLimitCell alloc] initWithFrame:NSZeroRect];
        cell.identifier = NSStringFromClass([HWMJoinConfLimitCell class]);
    }
    return cell;
}

- (instancetype)initWithFrame:(NSRect)frameRect {
    if (self = [super initWithFrame:frameRect]) {
        self.wantsLayer = YES;
        self.layer.backgroundColor = [NSColor whiteColor].CGColor;
        [self commonInit];
        [self setupUI];
    }
    return self;
}

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];

    // Drawing code here.
}

- (void)commonInit {
    _enable = YES;
    _currentIndex = 0;
}

#pragma mark - UI
- (void)setupUI {
    [self addSubview:self.titleLabel];
    [self addSubview:self.limitLabel];

    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self).offset(120);
        make.centerY.equalTo(self);
        make.width.mas_equalTo(150);
    }];

    [self.limitLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.trailing.equalTo(self).offset(-120);
        make.centerY.equalTo(self);
    }];
}

#pragma mark - Event
- (void)limitBtnClick {
    if (_menuTitles.count == 0) {
        return;
    }
    NSMenu *menu = [[NSMenu alloc] init];
    NSArray *arr = _menuTitles;

    for (NSInteger i = 0; i < arr.count; i++) {
        NSString *title = arr[i];
        NSMenuItem *item = [[NSMenuItem alloc] initWithTitle:title action:@selector(selectMenuItem:) keyEquivalent:@""];
        item.target = self;
        item.tag = i;
        [menu addItem:item];
    }
    NSPoint point = NSMakePoint(self.frame.origin.x, self.frame.origin.y + 30);
    [menu popUpMenuPositioningItem:nil atLocation:point inView:self.limitLabel];
}

- (void)selectMenuItem:(NSMenuItem *)item {
    NSString *title = item.title;
    NSInteger index = item.tag;
    self.currentIndex = index;
    if (_selectMenuItemHandler) {
        _selectMenuItemHandler(index,title);
    }
}

- (void)setCurrentIndex:(NSInteger)currentIndex {
    if (currentIndex != _currentIndex) {
        _currentIndex = currentIndex;
        [self updateDisplaySubtitle];
    }
}

- (void)setMenuTitles:(NSArray *)menuTitles {
    _menuTitles = menuTitles;
    [self updateDisplaySubtitle];
}

- (void)setEnable:(BOOL)enable {
    if (enable != _enable) {
        _enable = enable;
        self.limitLabel.enabled = enable;
    }
}

- (void)updateDisplaySubtitle {
    if (_menuTitles.count > _currentIndex) {
        NSString *title = _menuTitles[_currentIndex];
        self.limitLabel.attributedTitle = [[NSAttributedString alloc] initWithString:title attributes:@{ NSFontAttributeName: [NSFont systemFontOfSize:13], NSForegroundColorAttributeName:[NSColor colorWithRGB:0x333333] }];
    }
}

- (void)setTitle:(NSString *)title {
    _title = title;
    if (title.length > 0) {
        self.titleLabel.stringValue = title;
    }
}

#pragma mark - Lazy
- (NSTextField *)titleLabel {
    if (!_titleLabel) {
        _titleLabel = [NSTextField hwm_fieldWithTitle:@"允许入会" titleColor:[NSColor colorWithRGB:0x666666] font:[NSFont systemFontOfSize:13]];
    }
    return _titleLabel;
}

- (NSButton *)limitLabel {
    if (!_limitLabel) {
        _limitLabel = [NSButton buttonWithTitle:@"所有人" font:[NSFont systemFontOfSize:13] fontColor:[NSColor blackColor] target:self action:@selector(limitBtnClick)];
        _limitLabel.layer.backgroundColor = [NSColor whiteColor].CGColor;
        _limitLabel.image = [NSImage imageNamed:@"arrow_right"];
        _limitLabel.imagePosition = NSImageRight;
    }
    return _limitLabel;
}



@end
