//
//  HWMConfigLinkPrefixController.m
//  HWMUISDKNativeDemo
//
//  Created by linweiqiang on 2024/7/29.
//  Copyright © 2024 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMConfigLinkPrefixController.h"
#import "HWMInputView.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMConfigLinkPrefixController ()

@property (nonatomic, strong) HWMInputView *linkPrefixInputView;
@property (nonatomic, strong) NSButton *confirmBtn;

@end

@implementation HWMConfigLinkPrefixController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

#pragma mark - Event

- (void)confirmBtnClick {
    [HWMSdk getSdkConfig].linkPrefix = self.linkPrefixInputView.textField.stringValue;
    [HWMConsoleManager shareInstance].console = @"config link prefix";
}

#pragma mark - UI

- (void)setupUI {
    [self.view addSubview:self.linkPrefixInputView];
    [self.linkPrefixInputView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(100);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(400);
    }];
    
    [self.view addSubview:self.confirmBtn];
    [self.confirmBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.top.equalTo(self.linkPrefixInputView.mas_bottom).offset(60);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

#pragma mark - Lazy

- (HWMInputView *)linkPrefixInputView {
    if (!_linkPrefixInputView) {
        _linkPrefixInputView = [[HWMInputView alloc] init];
        _linkPrefixInputView.title = @"会议链接前缀";
        _linkPrefixInputView.placeholder = @"";
    }
    return _linkPrefixInputView;
}

- (NSButton *)confirmBtn {
    if (!_confirmBtn) {
        _confirmBtn = [NSButton buttonWithTitle:@"确定" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(confirmBtnClick)];
        _confirmBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _confirmBtn.layer.cornerRadius = 4.0;
        _confirmBtn.layer.masksToBounds = YES;
    }
    return _confirmBtn;
}

@end
