//
//  HWMGeneralWatchController.m
//  HWMUISDKNativeDemo
//
//  Created by p00576758 on 2023/7/27.
//  Copyright © 2023 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMGeneralWatchController.h"
#import <HWMUISDK/HWMUISDK.h>
#import "HWMWatchView.h"
#import "HWMInputView.h"
#import "HWMGeneralWatchWindow.h"

static CGFloat const kButtonWidth = 260.f;
static CGFloat const kButtonHeight = 35.f;

@interface HWMGeneralWatchController () <HWMBizNotificationHandler, HWMGeneralWatchWindowDelegate>
@property (nonatomic, strong) NSView *containerView;
@property (nonatomic, strong) HWMWatchView *singleView;
@property (nonatomic, strong) HWMWatchView *firstView;
@property (nonatomic, strong) HWMWatchView *secondView;
@property (nonatomic, strong) NSImageView *imageView;

@property (nonatomic, strong) NSButton *addWatchWindowBtn;

@property (nonatomic, strong) HWMInputView *userIdView;
@property (nonatomic, strong) HWMInputView *wndTypeView;
@property (nonatomic, strong) HWMInputView *padLeftView;
@property (nonatomic, strong) HWMInputView *padRightView;
@property (nonatomic, strong) HWMInputView *padTopView;
@property (nonatomic, strong) HWMInputView *padBottomView;

@property (nonatomic, strong) NSButton *startWatch;
@property (nonatomic, strong) NSButton *closeWatch;

@property (nonatomic, strong) NSMutableArray *watchModelList;

@end

@implementation HWMGeneralWatchController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
    [self setupDelegate];
}

- (void)setupDelegate {
    [[HWMSdk getSdkConfig] subscribeBizNotificationHandler:self];
}

- (void)setupUI {
    [self.view addSubview:self.containerView];
    [self.containerView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(50);
        make.centerX.equalTo(self.view.mas_centerX).offset(-75);
        make.width.mas_equalTo(300);
    }];
    [self.containerView addSubview:self.userIdView];
    [self.containerView addSubview:self.wndTypeView];
    [self.containerView addSubview:self.padLeftView];
    [self.containerView addSubview:self.padRightView];
    [self.containerView addSubview:self.padTopView];
    [self.containerView addSubview:self.padBottomView];

    [self.userIdView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.containerView).offset(10);
        make.leading.equalTo(self.containerView);
        make.height.mas_equalTo(30);
        make.width.mas_equalTo(300);
    }];
    
    [self.wndTypeView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.userIdView.mas_bottom).offset(10);
        make.leading.equalTo(self.userIdView);
        make.size.equalTo(self.userIdView);
    }];
    
    [self.padLeftView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.wndTypeView.mas_bottom).offset(10);
        make.leading.equalTo(self.userIdView);
        make.size.equalTo(self.userIdView);
    }];
    
    [self.padRightView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.padLeftView.mas_bottom).offset(10);
        make.leading.equalTo(self.userIdView);
        make.size.equalTo(self.userIdView);
    }];
    
    [self.padTopView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.padRightView.mas_bottom).offset(10);
        make.leading.equalTo(self.userIdView);
        make.size.equalTo(self.userIdView);
    }];
    
    [self.padBottomView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.padTopView.mas_bottom).offset(10);
        make.leading.equalTo(self.userIdView);
        make.size.equalTo(self.userIdView);
        make.bottom.equalTo(self.containerView.mas_bottom).offset(-10);
    }];
    
    self.addWatchWindowBtn = self.closeWatch = [self creatbButtonWithTitle:@"添加选看窗口" tag:0];;
    self.addWatchWindowBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
    self.addWatchWindowBtn.layer.cornerRadius = 4.0;
    self.addWatchWindowBtn.layer.masksToBounds = YES;
    [self.view addSubview:self.addWatchWindowBtn];
    [self.addWatchWindowBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.containerView.mas_trailing).offset(50);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(100);
        make.centerY.equalTo(self.containerView.mas_centerY);
    }];
        
    self.startWatch = [self creatbButtonWithTitle:@"发起选看" tag:1];
    [self.view addSubview:self.startWatch];
    [self.startWatch mas_makeConstraints:^(MASConstraintMaker *make) {
        make.trailing.equalTo(self.view.mas_centerX).offset(-100);
        make.top.equalTo(self.containerView.mas_bottom).offset(100);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(160);
    }];
    
    self.closeWatch = [self creatbButtonWithTitle:@"关闭选看" tag:2];
    [self.view addSubview:self.closeWatch];
    [self.closeWatch mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.view.mas_centerX).offset(100);
        make.top.equalTo(self.startWatch);
        make.size.equalTo(self.startWatch);
    }];
}

- (NSButton *)creatbButtonWithTitle:(NSString *)title tag:(NSInteger)tag {
    NSButton *button = [NSButton buttonWithTitle:title font:nil fontColor:[NSColor whiteColor] target:self action:@selector(buttonEvent:)];
    button.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
    button.layer.cornerRadius = 4.0;
    button.layer.masksToBounds = YES;
    button.tag = tag;
    return button;
}

- (void)buttonEvent:(NSButton *)button {
    if (![HWMSdk hasInit]) {
        [HWMConsoleManager shareInstance].console = @"no init";
        return;
    }
    if (button.tag == 0) {
        [self clickWatchBtn];
        [HWMConsoleManager shareInstance].console = @"添加选看窗口";
    } else if (button.tag == 1) {
        [self startGeneralWatch];
        [HWMConsoleManager shareInstance].console = @"发起选看";
    } else if (button.tag == 2) {
        [self closeGeneralWatch];
        [HWMConsoleManager shareInstance].console = @"关闭选看";
    }
}

- (void)closeGeneralWatch {
    if (self.firstView) {
        [self.firstView removeFromSuperview];
        self.firstView = nil;
    }
    if (self.secondView) {
        [self.secondView removeFromSuperview];
        self.secondView = nil;
    }
    if (self.singleView) {
        [self.singleView removeFromSuperview];
        self.singleView = nil;
    }
    
    self.watchModelList = [NSMutableArray array];
    
    [self closeUnDestroyWatchWindow];
    
    [[HWMBizSdk getBizOpenApi] generalWatchWithWatchInfo:@[]];
}

- (void)closeUnDestroyWatchWindow {
    for (NSWindow *window in NSApp.windows) {
        if ([window isKindOfClass:NSClassFromString(@"HWMGeneralWatchWindow")]) {
            [window close];
        }
    }
}

- (void)startGeneralWatch {
    HWMUISDKWatchListInfoModel *modelList = [[HWMUISDKWatchListInfoModel alloc] init];
    modelList.watchList = self.watchModelList;
    HWMSDKERR result = [[HWMBizSdk getBizOpenApi] generalWatchWithWatchInfo:modelList];
    if (result != HWMSDKSdkerrSuccess) {
        NSMutableString *tips = [[NSMutableString alloc] initWithString:@"generalWatchWithWatchInfo failed: "];
        [tips appendFormat:@"result is:%ld", result];
        [HWMConsoleManager shareInstance].console = tips;
    }
}

- (void)clickWatchBtn {
    if (![HWMSdk hasInit]) {
        [HWMConsoleManager shareInstance].console = @"no init";
        return;
    }
    HWMGeneralWatchWindow *watchWindow = [[HWMGeneralWatchWindow alloc] init];
    [watchWindow setFrame:CGRectMake(0, 61, 300, 300) display:YES];
    [watchWindow setStyleMask:NSWindowStyleMaskTitled | NSWindowStyleMaskClosable];
    [watchWindow makeKeyAndOrderFront:nil];
    watchWindow.releasedWhenClosed = NO;
    watchWindow.watchWindowDelegate = self;
    
    HWMWatchView *watchView = [[HWMWatchView alloc] init];
    watchView.wantsLayer = YES;
    watchView.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
    watchView.userId = self.userIdView.textField.integerValue;
    [watchWindow.contentView addSubview:watchView];
    [watchView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(watchWindow.contentView);
    }];
    
    watchWindow.renderHandle = (NSUInteger)watchView;
    
    HWMUISDKWatchItemModel *watchModel = [[HWMUISDKWatchItemModel alloc] init];
    watchModel.padding = [[HWMUISDKRectInfoModel alloc] init];
    watchModel.renderHandle = (NSUInteger)watchView;
    
    watchModel.userId = self.userIdView.textField.integerValue;
    watchModel.wndType = self.wndTypeView.textField.integerValue;
    watchModel.padding.left = self.padLeftView.textField.integerValue;
    watchModel.padding.right = self.padRightView.textField.integerValue;
    watchModel.padding.top = self.padTopView.textField.integerValue;
    watchModel.padding.bottom = self.padBottomView.textField.integerValue;
    
    [self.watchModelList addObject:watchModel];
}

- (NSArray<NSString *> *)titleArr {
    return @[@"userId", @"wndType", @"pad.left", @"pad.right", @"pad.top", @"pad.bottom"];
}

- (NSView *)containerView {
    if (!_containerView) {
        _containerView = [[NSView alloc] init];
        _containerView.layer.backgroundColor = [NSColor clearColor].CGColor;
    }
    return _containerView;
}

- (HWMInputView *)userIdView {
    if (!_userIdView) {
        _userIdView = [[HWMInputView alloc] init];
        _userIdView.title = @"userId:";
        _userIdView.placeholder = @"请输入userId";
    }
    return _userIdView;
}

- (HWMInputView *)wndTypeView {
    if (!_wndTypeView) {
        _wndTypeView = [[HWMInputView alloc] init];
        _wndTypeView.title = @"wndType:";
        _wndTypeView.placeholder = @"请输入窗口类型";
    }
    return _wndTypeView;
}

- (HWMInputView *)padLeftView {
    if (!_padLeftView) {
        _padLeftView = [[HWMInputView alloc] init];
        _padLeftView.title = @"padding.left:";
        _padLeftView.placeholder = @"请输入左边距";
    }
    return _padLeftView;
}

- (HWMInputView *)padRightView {
    if (!_padRightView) {
        _padRightView = [[HWMInputView alloc] init];
        _padRightView.title = @"padding.right:";
        _padRightView.placeholder = @"请输入右边距";
    }
    return _padRightView;
}

- (HWMInputView *)padTopView {
    if (!_padTopView) {
        _padTopView = [[HWMInputView alloc] init];
        _padTopView.title = @"padding.top:";
        _padTopView.placeholder = @"请输入上边距";
    }
    return _padTopView;
}

- (HWMInputView *)padBottomView {
    if (!_padBottomView) {
        _padBottomView = [[HWMInputView alloc] init];
        _padBottomView.title = @"padding.bottom:";
        _padBottomView.placeholder = @"请输入下边距";
    }
    return _padBottomView;
}

- (NSMutableArray *)watchModelList {
    if (!_watchModelList) {
        _watchModelList = [NSMutableArray array];
    }
    return _watchModelList;
}

#pragma mark - HWMBizNotificationHandler

- (void)onVideoStreamTypeChanged:(HWMUISDKVideoStreamTypeInfoModel *)videoStreamTypeInfo {
    NSMutableString *tips = [[NSMutableString alloc] initWithString:@"onVideoStreamTypeChanged: "];
    [tips appendFormat:@"userId:%ld, isOpen:%ld", videoStreamTypeInfo.userId, videoStreamTypeInfo.streamType];
    [HWMConsoleManager shareInstance].console = tips;
}

- (void)onVideoAttendeeListChanged {
    [HWMConsoleManager shareInstance].console = @"onVideoAttendeeListChanged";
}

- (NSImageView *)imageView {
    if (!_imageView) {
        _imageView = [NSImageView new];
        _imageView.image = [NSImage imageNamed:@"AppIcon"];
    }
    return _imageView;
}


- (void)generalWatchWindowClosed:(NSUInteger)renderHandle {
    NSMutableArray *modelList = [NSMutableArray arrayWithCapacity:0];
    [self.watchModelList enumerateObjectsUsingBlock:^(HWMUISDKWatchItemModel *_Nonnull obj, NSUInteger idx, BOOL *_Nonnull stop) {
        if (obj.renderHandle != renderHandle) {
            [modelList addObject:obj];
        }
    }];
    self.watchModelList = modelList;
}


@end
