//
//  HWMSetAVDeviceController.m
//  HWMUISDKNativeDemo
//
//  Created by p00576758 on 2023/7/27.
//  Copyright © 2023 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSetAVDeviceController.h"
#import "HWMSDKTableView.h"
#import "HWMSwitchCell.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMSetAVDeviceController ()<HWMSDKTableViewDataSourse, HWMSDKTableViewDelegate, HWMSwitchCellDelegate, HWMBizNotificationHandler>
@property (nonatomic, strong) HWMSDKTableView *listView;
@property (nonatomic, copy) NSArray *dataArr;
@property (nonatomic, assign) BOOL isMicOpen;
@property (nonatomic, assign) BOOL isCamOpen;
@property (nonatomic, assign) BOOL isSpkOpen;

@end

@implementation HWMSetAVDeviceController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupData];
    [self setupUI];
    [self setupDelegate];
}

- (void)setupData {
    self.dataArr = @[@"麦克风", @"摄像头", @"扬声器"];
}

- (void)setupUI {
    self.listView = [[HWMSDKTableView alloc] initTableViewClomuIdentifier:@"AVDeviceConfig"];
    self.listView.delegate = self;
    self.listView.dataSource = self;
    [self.view addSubview:self.listView];
    [self.listView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.and.top.equalTo(self.view).offset(15);
        make.trailing.equalTo(self.view).offset(-15);
        make.bottom.equalTo(self.view).offset(-15);
    }];
}

- (void)setupDelegate {
    [[HWMSdk getSdkConfig] subscribeBizNotificationHandler:self];
}

#pragma mark - HWMSDKTableViewDelegate
- (NSInteger)numberOfRowsInTableView:(NSTableView *)tableView {
    return self.dataArr.count;
}

- (NSView *)tableView:(NSTableView *)tableView viewForTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row {
    HWMSwitchCell *cell = [HWMSwitchCell initSwitchCell:tableView ower:self];
    cell.index = row;
    cell.title = self.dataArr[row];
    cell.delegate = self;
    if (row == 0) {
        cell.state = self.isMicOpen;
    } else if (row == 1) {
        cell.state = self.isCamOpen;
    } else if (row == 2) {
        cell.state = self.isSpkOpen;
    }
    return cell;
}

- (void)switchStateChanged:(BOOL)state index:(NSInteger)index {
    HWMSwitchCell *cell = [self.listView.listView viewAtColumn:0 row:index makeIfNecessary:NO];
    HWMUISDKDeviceStateInfoModel *model = [[HWMUISDKDeviceStateInfoModel alloc] init];
    model.isOpen = state;
    if ([HWMSdk hasInit]) {
        if (index == 0) {
            model.deviceType = HWMUISDKDeviceTypeMic;
            [[HWMBizSdk getBizOpenApi] AVDeviceCtrlWithStateInfo:model];
        } else if (index == 1) {
            model.deviceType = HWMUISDKDeviceTypeCamera;
            [[HWMBizSdk getBizOpenApi] AVDeviceCtrlWithStateInfo:model];
        }else if (index == 2) {
            model.deviceType = HWMUISDKDeviceTypeSpeaker;
            [[HWMBizSdk getBizOpenApi] AVDeviceCtrlWithStateInfo:model];
        }
    } else {
        if (index == 0) {
            cell.state = self.isMicOpen;
        } else if (index == 1) {
            cell.state = self.isCamOpen;
        } else if (index == 2) {
            cell.state = self.isSpkOpen;
        }
        [HWMConsoleManager shareInstance].console = @"no init";
    }
}

- (CGFloat)tableView:(NSTableView *)tableView heightOfRow:(NSInteger)row {
    return 40.0;
}


#pragma mark - HWMBizNotificationHandler
/// 会中音视频设备控制状态变化通知
- (void)onAVDeviceCtrlStateChanged:(HWMUISDKDeviceStateInfoModel *)stateInfo {
    NSMutableString *tips = [[NSMutableString alloc] initWithString:@"onAVDeviceCtrlStateChanged: "];
    [tips appendFormat:@"deviceType:%ld, isOpen:%d", stateInfo.deviceType, stateInfo.isOpen];
    switch (stateInfo.deviceType) {
        case HWMUISDKDeviceTypeMic:
            self.isMicOpen = stateInfo.isOpen;
            break;
        case HWMUISDKDeviceTypeCamera:
            self.isCamOpen = stateInfo.isOpen;
            break;
        case HWMUISDKDeviceTypeSpeaker:
            self.isSpkOpen = stateInfo.isOpen;
            break;
        default:
            break;
    }
    [HWMConsoleManager shareInstance].console = tips;
}

- (void)onSpeakerListChanged:(HWMUISDKSpeakerListModel *)speakerListInfo {
    NSMutableString *itemsString = [[NSMutableString alloc] init];
    [speakerListInfo.speakers enumerateObjectsUsingBlock:^(HWMUISDKConfSpeakerModel * _Nonnull speakerInfo, NSUInteger idx, BOOL * _Nonnull stop) {
        [itemsString appendFormat:@"与会者:\n昵称：%@\nuserId：%ld\n", speakerInfo.name, speakerInfo.userId];
    }];
    [HWMConsoleManager shareInstance].console = itemsString;
}

@end
