//
//  HWMSetAvatarStyleController.m
//  HWMUISDKNativeDemo
//
//  Created by linweiqiang on 2025/4/9.
//  Copyright © 2025 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSetAvatarStyleController.h"
#import "HWMInputView.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMSetAvatarStyleController ()

@property (nonatomic, strong) HWMInputView *backgroundColorInputView;
@property (nonatomic, strong) HWMInputView *textColorInputView;
@property (nonatomic, strong) HWMInputView *phoneIconPathInputView;
@property (nonatomic, strong) HWMInputView *boardIconPathInputView;
@property (nonatomic, strong) NSPopUpButton *nameShowTypeBtn;
@property (nonatomic, strong) NSPopUpButton *avatarShapeBtn;
@property (nonatomic, strong) NSButton *confirmBtn;
@property (nonatomic, strong) HWMUISDKAvatarStyleModel *avatarStyleModel;

@end

@implementation HWMSetAvatarStyleController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

#pragma mark - Event

- (void)nameShowTypeBtnAction:(NSPopUpButton *)sender {
    self.avatarStyleModel.nameShowType = sender.indexOfSelectedItem;
}

- (void)avatarShapeBtnAction:(NSPopUpButton *)sender {
    self.avatarStyleModel.avatarShape = sender.indexOfSelectedItem;
}

- (void)confirmBtnClick {
    self.avatarStyleModel.backgroundColor = self.backgroundColorInputView.textField.stringValue;
    self.avatarStyleModel.textColor = self.textColorInputView.textField.stringValue;
    self.avatarStyleModel.phoneIconPath = self.phoneIconPathInputView.textField.stringValue;
    self.avatarStyleModel.boardIconPath = self.boardIconPathInputView.textField.stringValue;
    HWMSDKERR errorCode = [[HWMBizSdk getBizOpenApi] setAvatarStyle:self.avatarStyleModel];
    if (errorCode == HWMSDKSdkerrSuccess) {
        [HWMConsoleManager shareInstance].console = @"set avatar style success";
    } else {
        [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"set avatar style failed, error: %ld", errorCode];
    }
}

#pragma mark - UI

- (void)setupUI {
    [self.view addSubview:self.backgroundColorInputView];
    [self.backgroundColorInputView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(60);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(300);
    }];
    
    [self.view addSubview:self.textColorInputView];
    [self.textColorInputView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.backgroundColorInputView.mas_bottom);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(300);
    }];
    
    [self.view addSubview:self.phoneIconPathInputView];
    [self.phoneIconPathInputView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.textColorInputView.mas_bottom);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(300);
    }];
    
    [self.view addSubview:self.boardIconPathInputView];
    [self.boardIconPathInputView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.phoneIconPathInputView.mas_bottom);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(300);
    }];
    
    [self.view addSubview:self.nameShowTypeBtn];
    [self.nameShowTypeBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.boardIconPathInputView.mas_bottom);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(300);
    }];
    
    [self.view addSubview:self.avatarShapeBtn];
    [self.avatarShapeBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.nameShowTypeBtn.mas_bottom);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(300);
    }];
    
    [self.view addSubview:self.confirmBtn];
    [self.confirmBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.avatarShapeBtn.mas_bottom).offset(20);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

#pragma mark - Lazy

- (HWMUISDKAvatarStyleModel *)avatarStyleModel {
    if (!_avatarStyleModel) {
        _avatarStyleModel = [[HWMUISDKAvatarStyleModel alloc] init];
    }
    return _avatarStyleModel;
}

- (HWMInputView *)backgroundColorInputView {
    if (!_backgroundColorInputView) {
        _backgroundColorInputView = [[HWMInputView alloc] init];
        _backgroundColorInputView.title = @"背景颜色";
        _backgroundColorInputView.placeholder = @"#FF0000FF";
    }
    return _backgroundColorInputView;
}

- (HWMInputView *)textColorInputView {
    if (!_textColorInputView) {
        _textColorInputView = [[HWMInputView alloc] init];
        _textColorInputView.title = @"文字颜色";
        _textColorInputView.placeholder = @"#FFFFFFFF";
    }
    return _textColorInputView;
}

- (HWMInputView *)phoneIconPathInputView {
    if (!_phoneIconPathInputView) {
        _phoneIconPathInputView = [[HWMInputView alloc] init];
        _phoneIconPathInputView.title = @"手机图标路径";
        _phoneIconPathInputView.placeholder = @"";
    }
    return _phoneIconPathInputView;
}

- (HWMInputView *)boardIconPathInputView {
    if (!_boardIconPathInputView) {
        _boardIconPathInputView = [[HWMInputView alloc] init];
        _boardIconPathInputView.title = @"大屏图标路径";
        _boardIconPathInputView.placeholder = @"";
    }
    return _boardIconPathInputView;
}

- (NSPopUpButton *)nameShowTypeBtn {
    if (!_nameShowTypeBtn) {
        _nameShowTypeBtn = [[NSPopUpButton alloc] init];
        _nameShowTypeBtn.target = self;
        _nameShowTypeBtn.action = @selector(nameShowTypeBtnAction:);
        [_nameShowTypeBtn addItemsWithTitles:@[@"显示拼音首字母", @"显示姓氏"]];
    }
    return _nameShowTypeBtn;
}

- (NSPopUpButton *)avatarShapeBtn {
    if (!_avatarShapeBtn) {
        _avatarShapeBtn = [[NSPopUpButton alloc] init];
        _avatarShapeBtn.target = self;
        _avatarShapeBtn.action = @selector(avatarShapeBtnAction:);
        [_avatarShapeBtn addItemsWithTitles:@[@"圆形头像"]];
    }
    return _avatarShapeBtn;
}

- (NSButton *)confirmBtn {
    if (!_confirmBtn) {
        _confirmBtn = [NSButton buttonWithTitle:@"确定" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(confirmBtnClick)];
        _confirmBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _confirmBtn.layer.cornerRadius = 4.0;
        _confirmBtn.layer.masksToBounds = YES;
    }
    return _confirmBtn;
}

@end
