//
//  HWMSetConfBarMenuController.m
//  HWMUISDKNativeDemo
//
//  Created by guoyongliang/gwx917154 on 2022/5/30.
//  Copyright © 2022 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSetConfBarMenuController.h"
#import <HWMUISDK/HWMUISDK.h>
#import "HWMStatusBarMenuConfigDataSource.h"

@interface HWMSetConfBarMenuController ()

@property (nonatomic, strong) NSButton *defaultStatusBarMenuButton;
@property (nonatomic, strong) NSButton *customStatusBarMenuButton;

@property (nonatomic, strong) NSButton *enableClickRecordButton;
@property (nonatomic, strong) NSButton *disableClickRecordButton;


@end

@implementation HWMSetConfBarMenuController
- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setupUI];
}

- (void)setupUI {
    self.defaultStatusBarMenuButton = [NSButton buttonWithTitle:@"默认" target:self action:@selector(customButtonClicked:) stateValueOn:YES];
    self.customStatusBarMenuButton = [NSButton buttonWithTitle:@"自定注入" target:self action:@selector(customButtonClicked:) stateValueOn:NO];
    self.enableClickRecordButton = [NSButton buttonWithTitle:@"录制可点击" target:self action:@selector(buttonClicked:) stateValueOn:YES];
    self.disableClickRecordButton = [NSButton buttonWithTitle:@"录制不可点击" target:self action:@selector(buttonClicked:) stateValueOn:NO];
    
    [self.view addSubview:self.defaultStatusBarMenuButton];
    [self.view addSubview:self.customStatusBarMenuButton];
    [self.view addSubview:self.enableClickRecordButton];
    [self.view addSubview:self.disableClickRecordButton];

    [self.defaultStatusBarMenuButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(@120);
        make.leading.mas_equalTo(200);
    }];
    
    [self.customStatusBarMenuButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(self.defaultStatusBarMenuButton);
        make.trailing.mas_equalTo(-200);
    }];
    
    [self.enableClickRecordButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.defaultStatusBarMenuButton).mas_offset(50);
        make.leading.mas_equalTo(200);
    }];
    
    [self.disableClickRecordButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(self.enableClickRecordButton);
        make.trailing.mas_equalTo(-200);
    }];

}

- (void)customButtonClicked:(NSButton *)btn {
    BOOL isCustom = self.defaultStatusBarMenuButton.state == NSControlStateValueOff;
    [HWMSdk getSdkConfig].statusBarMenuHandler = isCustom ? [HWMStatusBarMenuConfigDataSource shareInstance] : nil;
    [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"set status bar menu is %@", isCustom ? @"custom " : @"default"];
}

- (void)buttonClicked:(NSButton *)btn {
    BOOL enableClick = self.enableClickRecordButton.state == NSControlStateValueOn;
    [HWMStatusBarMenuConfigDataSource shareInstance].isShowRecord = enableClick;
    [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"set %@ click record bar menu", enableClick ? @"enable " : @"disable"];
}


@end
