//
//  HWMSetConfMuteController.m
//  HWMUISDKNativeDemo
//
//  Created by guoyongliang/gwx917154 on 2022/5/30.
//  Copyright © 2022 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSetConfMuteController.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMSetConfMuteController ()
@property (nonatomic, strong) NSButton *allowButton;
@property (nonatomic, strong) NSButton *notAllowButton;
@property (nonatomic, strong) NSButton *confirmButton;
@end

@implementation HWMSetConfMuteController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setupUI];
}

- (void)setupUI {
    self.allowButton = [NSButton buttonWithTitle:@"提示" target:self action:@selector(buttonClicked:) stateValueOn:YES];
    self.notAllowButton = [NSButton buttonWithTitle:@"不提示" target:self action:@selector(buttonClicked:) stateValueOn:NO];
    
    [self.view addSubview:self.allowButton];
    [self.view addSubview:self.notAllowButton];
    [self.view addSubview:self.confirmButton];

    [self.allowButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(@120);
        make.leading.mas_equalTo(200);
    }];
    
    [self.notAllowButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(self.allowButton);
        make.trailing.mas_equalTo(-200);
    }];

    [self.confirmButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.bottom.equalTo(self.view).offset(-100);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

- (NSButton *)confirmButton {
    if (!_confirmButton) {
        _confirmButton = [NSButton buttonWithTitle:@"确定" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(confirmButtonClick)];
        _confirmButton.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _confirmButton.layer.cornerRadius = 4.0;
        _confirmButton.layer.masksToBounds = YES;
    }
    return _confirmButton;
}

- (void)buttonClicked:(NSButton *)btn {
}

- (void)confirmButtonClick{
    HWMSDKVoicePromptsModel * model = [[HWMSDKVoicePromptsModel alloc] init];
    model.disableMutePrompt = self.notAllowButton.state == NSControlStateValueOn;
    HWMSDKERR res = [[HWMBizSdk getBizOpenApi] disableVoicePrompts:model];
    [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"set disable voice prompts:%d  error code:%zd", model.disableMutePrompt, res];
}
@end
