//
//  HWMSetGuaranteeIpAddrsViewController.m
//  HWMUISDKNativeDemo
//
//  Created by 204053 on 2023/10/28.
//  Copyright © 2023 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSetGuaranteeIpAddrsViewController.h"
#import "HWMInputView.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMSetGuaranteeIpAddrsViewController ()

@property (nonatomic, strong) HWMInputView *guarantIpAddrsInputView;
@property (nonatomic, strong) NSButton *confirmBtn;

@end

@implementation HWMSetGuaranteeIpAddrsViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

- (void)setupUI {
    [self.view addSubview:self.guarantIpAddrsInputView];
    [self.view addSubview:self.confirmBtn];

    [self.guarantIpAddrsInputView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(100);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(400);
    }];

    [self.confirmBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.top.equalTo(self.guarantIpAddrsInputView.mas_bottom).offset(60);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

- (void)confirmBtnClick {
    [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"%s",__func__];
    NSString *logPath = self.guarantIpAddrsInputView.textField.stringValue;
    if (logPath.length == 0) {
        [HWMConsoleManager shareInstance].console = @"please enter guarant ip addrs.";
        return;
    }

    HWMSDKERR result = [[HWMBizSdk getBizOpenApi] setGuaranteedIpAddresses:self.guarantIpAddrsInputView.textField.stringValue];
    NSString *tip = @"设置(会控)保底ip地址成功";
    if (result != HWMSDKSdkerrSuccess) {
        tip = [NSString stringWithFormat:@"设置(会控)保底ip地址失败[%ld]",result];
    }
    [HWMConsoleManager shareInstance].console = tip;
}

#pragma mark - Lazy
- (HWMInputView *)guarantIpAddrsInputView {
    if (!_guarantIpAddrsInputView) {
        _guarantIpAddrsInputView = [[HWMInputView alloc] init];
        _guarantIpAddrsInputView.title = @"设置(会控)保底ip地址";
        _guarantIpAddrsInputView.placeholder = @"用分号分割且最多4个";
    }
    return _guarantIpAddrsInputView;
}

- (NSButton *)confirmBtn {
    if (!_confirmBtn) {
        _confirmBtn = [NSButton buttonWithTitle:@"确定" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(confirmBtnClick)];
        _confirmBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _confirmBtn.layer.cornerRadius = 4.0;
        _confirmBtn.layer.masksToBounds = YES;
    }
    return _confirmBtn;
}

@end
