//
//  HWMSetNetworkModeController.m
//  HWMUISDKNativeDemo
//
//  Created by 江万里 on 2022/2/11.
//  Copyright © 2022 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSetNetworkModeController.h"
#import <HWMUISDK/HWMUISDK.h>
#import "NSViewController+HWMNavigation.h"

@interface HWMSetNetworkModeController ()

@property (nonatomic, strong) NSButton *autoBtn;
@property (nonatomic, strong) NSButton *innerBtn;
@property (nonatomic, strong) NSButton *outerBtn;


@property (nonatomic, strong) NSButton *confirmBtn;

@property (nonatomic, assign) HWMAccessType accessType;


@end

@implementation HWMSetNetworkModeController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
    // Do view setup here.
}


- (void)buttonClicked:(NSButton *)btn {
    self.accessType = btn.tag;
}


- (void)setupUI {
    [self.view addSubview:self.autoBtn];
    [self.view addSubview:self.innerBtn];
    
    [self.view addSubview:self.outerBtn];
    [self.view addSubview:self.confirmBtn];
    
    [self.autoBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(100);
        make.leading.equalTo(self.view).offset(50);
    }];
    
    [self.innerBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(100);
        make.centerX.equalTo(self.view);
    }];
    
    [self.outerBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(100);
        make.trailing.equalTo(self.view).offset(-50);
    }];
    
    [self.confirmBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.bottom.equalTo(self.view).offset(-100);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

- (void)confirmBtnClick {
    if (@available(macOS 10.13, *)) {
        [HWMSdk setNetworkModeWithAccessType:self.accessType];
        [HWMConsoleManager shareInstance].console = @"set network success";
        
    } else {
        // Fallback on earlier versions
        [HWMConsoleManager shareInstance].console = @"need macOS 10.13 and above";
    }
    
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(1 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [self.customNavigationController popViewControllerAnimated:YES];
    });
}

#pragma mark - Lazy
- (NSButton *)autoBtn {
    if (!_autoBtn) {
        _autoBtn = [[NSButton alloc] init];
        _autoBtn.bordered = NO;
        _autoBtn.font = [NSFont systemFontOfSize:12];
        _autoBtn.bezelStyle = NSBezelStyleRegularSquare;
        _autoBtn.state = NSControlStateValueOn;
        [_autoBtn setButtonType:NSButtonTypeRadio];
        [_autoBtn setTitle:@"默认"];
        _autoBtn.target = self;
        _autoBtn.action = @selector(buttonClicked:);
        _autoBtn.tag = HWMAccessTypeAuto;
    }
    return _autoBtn;
}

- (NSButton *)innerBtn {
    if (!_innerBtn) {
        _innerBtn = [[NSButton alloc] init];
        _innerBtn.bordered = NO;
        _innerBtn.font = [NSFont systemFontOfSize:12];
        _innerBtn.bezelStyle = NSBezelStyleRegularSquare;
        _innerBtn.state = NSControlStateValueOff;
        [_innerBtn setButtonType:NSButtonTypeRadio];
        [_innerBtn setTitle:@"内网"];
        _innerBtn.target = self;
        _innerBtn.action = @selector(buttonClicked:);
        _innerBtn.tag = HWMAccessTypeInner;
    }
    return _innerBtn;
}

- (NSButton *)outerBtn {
    if (!_outerBtn) {
        _outerBtn = [[NSButton alloc] init];
        _outerBtn.bordered = NO;
        _outerBtn.font = [NSFont systemFontOfSize:12];
        _outerBtn.bezelStyle = NSBezelStyleRegularSquare;
        _outerBtn.state = NSControlStateValueOff;
        [_outerBtn setButtonType:NSButtonTypeRadio];
        [_outerBtn setTitle:@"外网"];
        _outerBtn.target = self;
        _outerBtn.action = @selector(buttonClicked:);
        _outerBtn.tag = HWMAccessTypeOuter;
    }
    return _outerBtn;
}


- (NSButton *)confirmBtn {
    if (!_confirmBtn) {
        _confirmBtn = [NSButton buttonWithTitle:@"确定" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(confirmBtnClick)];
        _confirmBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _confirmBtn.layer.cornerRadius = 4.0;
        _confirmBtn.layer.masksToBounds = YES;
    }
    return _confirmBtn;
}



@end
