//
//  HWMSetRecordPathController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2021/10/20.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSetRecordPathController.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMSetRecordPathController ()

/// 默认地址
@property (nonatomic, strong) NSTextField *defaultLabel;

@property (nonatomic, strong) NSButton *setBtn;

@end

@implementation HWMSetRecordPathController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

#pragma mark - UI
- (void)setupUI {
    [self.view addSubview:self.defaultLabel];
    [self.view addSubview:self.setBtn];
    
    [self.defaultLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.view).offset(60);
        make.trailing.equalTo(self.view).offset(-60);
        make.top.equalTo(self.view).offset(60);
    }];
    
    [self.setBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.center.equalTo(self.view);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
    
    self.defaultLabel.stringValue = [NSString stringWithFormat:@"默认路径：%@", [[HWMSdk getOpenApi] getLocalReocrdPath].path];
}

#pragma mark - event
- (void)selectLocalRecordPath {
    if (![HWMSdk hasInit]) {
        [HWMConsoleManager shareInstance].console = @"no init";
        return;
    }
    NSOpenPanel *select = [NSOpenPanel openPanel];
    select.canChooseFiles = NO;
    select.canChooseDirectories = YES;
    select.prompt = @"确定";
    [select beginSheetModalForWindow:self.view.window completionHandler:^(NSModalResponse result) {
        if (result == 1) {
             [[HWMSdk getOpenApi] setLocalRecordPath:select.URL];
        }
    }];
}

#pragma mark - Lazy

- (NSTextField *)defaultLabel {
    if (!_defaultLabel) {
        _defaultLabel = [NSTextField hwm_fieldWithTitle:@"" titleColor:[NSColor colorWithRGB:0x333333] font:[NSFont systemFontOfSize:14]];
        _defaultLabel.lineBreakMode = NSLineBreakByWordWrapping;
        [_defaultLabel setContentCompressionResistancePriority:NSLayoutPriorityDefaultLow forOrientation:NSLayoutConstraintOrientationHorizontal];
    }
    return _defaultLabel;
}

- (NSButton *)setBtn {
    if (!_setBtn) {
        _setBtn = [NSButton buttonWithTitle:@"设置路径" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(selectLocalRecordPath)];
        _setBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _setBtn.layer.cornerRadius = 4.0;
        _setBtn.layer.masksToBounds = YES;
    }
    return _setBtn;
}


@end
