//
//  HWMLoginViewController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/24.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMLoginViewController.h"
#import "HWMInputView.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMLoginViewController ()

/// 输入框
@property (nonatomic, strong) HWMInputView *nameView;
/// 密码
@property (nonatomic, strong) HWMInputView *passView;
@property (nonatomic, strong) NSButton *loginBtn;
@property (nonatomic, strong) NSButton *loginStateBtn;
@property (nonatomic, strong) NSButton *loginTokenBtn;

@end

@implementation HWMLoginViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

#pragma mark - UI
- (void)setupUI {
    [self.view addSubview:self.nameView];
    [self.view addSubview:self.passView];
    [self.view addSubview:self.loginBtn];
    [self.view addSubview:self.loginStateBtn];
    [self.view addSubview:self.loginTokenBtn];

    [self.nameView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(100);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(300);
    }];
    
    [self.passView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.nameView.mas_bottom).offset(10);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(300);
    }];
    
    [self.loginBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.top.equalTo(self.passView.mas_bottom).offset(60);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
    
    [self.loginStateBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.top.equalTo(self.loginBtn.mas_bottom).offset(20);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
    
    [self.loginTokenBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.top.equalTo(self.loginStateBtn.mas_bottom).offset(20);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

#pragma mark - Event
- (void)login {
    
    if (![HWMSdk hasInit]) {
        [HWMConsoleManager shareInstance].console = @"no init";
        return;
    }
    
    NSString *account = self.nameView.textField.stringValue;
    NSString *password = self.passView.textField.stringValue;
    if (account.length == 0 || password.length == 0) {
        [HWMConsoleManager shareInstance].console = @"please enter account or password.";
        return;
    }
    
    [[HWMSdk getOpenApi] login:account password:password callback:^(NSError * _Nullable error, HWMLoginResult * _Nullable result) {
        if (error) {
            if (error.code == HWMSDKSdkLoginEErrMngFailed) {
                // HWMSDKSdkLoginEErrMngFailed 服务器降级，登录接收到此错误码可以继续调用入会接口
            }
            [HWMConsoleManager shareInstance].error = error;
        }else {
            [HWMConsoleManager shareInstance].console = @"login successful.";
            [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"login result: %@", result.description];
            [[NSUserDefaults standardUserDefaults] setBool:YES forKey:@"login"];
            [[NSUserDefaults standardUserDefaults] synchronize];
        }
    }];
}

- (void)getLoginState {
    HWMLoginState loginState = [[HWMBizSdk getBizOpenApi] getLoginState];
    switch (loginState) {
        case HWMLoginStateUnLogin: 
            [HWMConsoleManager shareInstance].console = @"未登录";
            break;
        case HWMLoginStateLogining:
            [HWMConsoleManager shareInstance].console = @"登录中";
            break;
        case HWMLoginStateLogined:
            [HWMConsoleManager shareInstance].console = @"已登录";
            break;
        case HWMLoginStateLogouting:
            [HWMConsoleManager shareInstance].console = @"登出中";
            break;
        default:
            break;
    }
}

- (void)getLoginToken {
    NSString *loginToken = [[HWMBizSdk getBizOpenApi] getLoginToken];
    [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"loginToken: %@", loginToken];
}

#pragma mark - Lazy

- (HWMInputView *)nameView {
    if (!_nameView) {
        _nameView = [[HWMInputView alloc] init];
        _nameView.title = @"账号:";
        _nameView.placeholder = @"请输入账号";
    }
    return _nameView;
}

- (HWMInputView *)passView {
    if (!_passView) {
        _passView = [[HWMInputView alloc] init];
        _passView.title = @"密码:";
        _passView.placeholder = @"请输入密码";
    }
    return _passView;
}

- (NSButton *)loginBtn {
    if (!_loginBtn) {
        _loginBtn = [NSButton buttonWithTitle:@"登录" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(login)];
        _loginBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _loginBtn.layer.cornerRadius = 4.0;
        _loginBtn.layer.masksToBounds = YES;
    }
    return _loginBtn;
}

- (NSButton *)loginStateBtn {
    if (!_loginStateBtn) {
        _loginStateBtn = [NSButton buttonWithTitle:@"获取登录状态" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(getLoginState)];
        _loginStateBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _loginStateBtn.layer.cornerRadius = 4.0;
        _loginStateBtn.layer.masksToBounds = YES;
    }
    return _loginStateBtn;
}

- (NSButton *)loginTokenBtn {
    if (!_loginTokenBtn) {
        _loginTokenBtn = [NSButton buttonWithTitle:@"获取登录Token" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(getLoginToken)];
        _loginTokenBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _loginTokenBtn.layer.cornerRadius = 4.0;
        _loginTokenBtn.layer.masksToBounds = YES;
    }
    return _loginTokenBtn;
}

@end
