//
//  NSString+HWMExtension.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/11/3.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "NSString+HWMSDKDemoExtension.h"

@implementation NSString (HWMSDKDemoExtension)

+ (NSString *)getLocalTimeZoneTimeWithTimeInterval:(NSTimeInterval)timeInteral format:(NSString *)format {
    
    if (timeInteral > 0) {
        NSDate *utcDate = [NSDate dateWithTimeIntervalSince1970:timeInteral];
        NSTimeZone* sourceTimeZone = [NSTimeZone timeZoneWithAbbreviation:@"UTC"];//或GMT
        NSTimeZone* destinationTimeZone = [NSTimeZone localTimeZone];
        NSInteger sourceGMTOffset = [sourceTimeZone secondsFromGMTForDate:utcDate];
        NSInteger destinationGMTOffset = [destinationTimeZone secondsFromGMTForDate:utcDate];
        NSTimeInterval interval = destinationGMTOffset - sourceGMTOffset;
        NSDate* destinationDateNow = [[NSDate alloc] initWithTimeInterval:interval sinceDate:utcDate];
        NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
        formatter.dateFormat = format.length > 0 ? format : @"HH:mm";
        NSString *time = [formatter stringFromDate:destinationDateNow];
        return time;
    }
    return @"";
}

+ (NSTimeInterval)getTimeIntervalWithDateString:(NSString *)dateString {
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"yyyy-MM-dd HH:mm"];
    NSDate *date = [dateFormatter dateFromString:dateString];
    NSTimeZone *currentZone = [NSTimeZone localTimeZone];
    NSInteger seconds = -[currentZone secondsFromGMTForDate:date];
    NSDate *utcDate = [NSDate dateWithTimeInterval:seconds sinceDate:date];
    NSTimeInterval timeInterval = [utcDate timeIntervalSince1970];
    return timeInterval;
}

+ (NSTimeInterval)getTimeStampWithDateString:(NSString *)dateString {
    return [self getTimeStampWithDateString:dateString format:nil];
}

+ (NSTimeInterval)getTimeStampWithDateString:(NSString *)dateString format:(NSString *)format {
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"yyyy-MM-dd HH:mm"];
    if (format && ![format isEqualToString:@""] && ![format isKindOfClass:[NSNull class]]) {
        [dateFormatter setDateFormat:format];
    }
    NSDate *date = [dateFormatter dateFromString:dateString];
    return [date timeIntervalSince1970];
}

+ (NSString *)timeStringFromTimeInterval:(NSTimeInterval)timeInteral {
    return [self timeStringFromTimeInterval:timeInteral format:@"yyyy-MM-dd HH:mm"];
}

+ (NSString *)timeStringFromTimeInterval:(NSTimeInterval)timeInteral format:(NSString *)format {
    if (timeInteral > 0) {
        NSDate *date = [NSDate dateWithTimeIntervalSince1970:timeInteral];
        NSTimeZone *timeZone = [NSTimeZone systemTimeZone];
        NSDateFormatter *formater = [[NSDateFormatter alloc] init];
        formater.dateFormat = format;
        formater.timeZone = timeZone;
        NSString *timeStr = [formater stringFromDate:date];
        return timeStr;
    }
    return @"";
}
@end
