//
//  NSView+HWMExtension.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/24.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "NSView+HWMExtension.h"

@implementation NSView (HWMExtension)

- (void)addTrackingAreaWithRect:(NSRect)rect {
    for (NSTrackingArea *area in self.trackingAreas) {
        [self removeTrackingArea:area];
    }
    NSTrackingAreaOptions options =  NSTrackingInVisibleRect | NSTrackingMouseEnteredAndExited | NSTrackingActiveAlways | NSTrackingCursorUpdate;
    NSTrackingArea *area = [[NSTrackingArea alloc] initWithRect:rect options:options owner:self userInfo:nil];
    [self addTrackingArea:area];
}

- (void)addTrackingArea {
    [self addTrackingAreaWithRect:self.bounds];

    //解决滚轮滑动时不触发 mouseEntered 与 mouseExited
    NSPoint point = [NSEvent mouseLocation];
    BOOL entered = CGRectContainsPoint(self.frame, point);
    if (entered) {
        [self mouseEntered:self.window.currentEvent];
    } else {
        [self mouseExited:self.window.currentEvent];
    }
}

@end
