//
//  HWMCreateConfParam.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/10/12.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMAttendeeInfo.h"
#import "HWMSdkDefine.h"
#import "HWMSDKCommonDefine.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMCreateConfParam : NSObject
/// （必填）会议主题
@property (nonatomic, strong) NSString *subject;

/// 成员列表，可选 自己信息不需要传递
@property (nonatomic, strong) NSArray <HWMAttendeeInfo *> *members;

/// 是否打开摄像头, 默认关闭
@property (nonatomic, assign) BOOL isCameraOn;

/// 是否打开麦克风， 默认打开
@property (nonatomic, assign) BOOL isMicOn;

/// 是否自动录制会议，默认关闭
@property (nonatomic, assign) BOOL isAutoRecord;

/// 是否打开会议录制， 默认关闭
@property (nonatomic, assign) BOOL isRecordOn;

/// (选填）若想创建及时的个人VMR会议，需要传递个人会议或者云会议室VMRID 随机会议不传递
@property (nonatomic, copy) NSString *vmrId;

/// (选填）允许入会范围限制 默认所有人
@property (nonatomic, assign) HWMJoinConfRestrictionType callInRestrictionType;

/// (选填) 会议是否无密码，默认为否，有密码。创建个人VMR会议时此选项无效
@property (nonatomic, assign) BOOL noPassword;

/// (选填) 指定来宾入会密码，默认不填，随机生成密码。创建个人VMR会议时此选项无效，使用个人VMR会议室密码
@property (nonatomic, copy) NSString *guestPwd;

/// (选填) 是否指定创建视频会议，默认视频
@property (nonatomic, assign) BOOL isVideo;

/// (选填) 云会议室的会议ID类型，默认固定类型
@property (nonatomic, assign) HWMVmrConfIdType vmrConfIdType;

/// (选填)  是否开启等候室。需开通等候室功能后该设置才生效。
@property (nonatomic, assign) BOOL isOpenWaitingRoom;

/// (选填)  自定义信息
@property (nonatomic, copy) NSString *customInfo;

/// (选填）会议最大与会人数，默认0
@property (nonatomic, assign) NSUInteger concurrentParticipants;

/// 会议资源类型
@property (nonatomic, assign) HWMConfResType confResType;

/// 个人客户端入会是否自动静音
@property (nonatomic, assign) HWMAutoMuteType autoMuteMode;

/// 会议室设备入会是否自动静音
@property (nonatomic, assign) HWMAutoMuteType hardTerminalAutoMuteMode;

/// 是否支持水印
@property (nonatomic, assign) BOOL supportWatermark;

/// 录制时，智能会议纪要的默认状态，仅支持会议纪要时生效
@property (nonatomic, assign) HWMSummaryState defaultSummaryState;

/// 是否免审核自动发布纪要
@property (nonatomic, assign) BOOL autoPublishSummary;

@end

NS_ASSUME_NONNULL_END
