//
//  HWMLinkConfParam.h
//  HWMUISDK
//
//  Created by songqi on 2020/12/26.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface HWMLinkConfParam : NSObject

/// 根据链接解析出的服务器地址
@property (nonatomic, copy) NSString *siteUrl;

/// 根据链接解析出的随机数
@property (nonatomic, copy) NSString *random;

/// 会议id所属站点的前缀
@property (nonatomic, copy) NSString *idPrefix;

/// 会议中的昵称。如果不传入，会使用设备名字  长度不超过64
@property(nonatomic, copy) NSString *nickname;

/// 会中显示的与会者名称 中文昵称
@property (nonatomic, copy) NSString *aliasCN;

/// 会中显示的与会者名称 英文昵称
@property (nonatomic, copy) NSString *aliasEN;

/// 是否打开摄像头.默认关闭
@property(nonatomic, assign) BOOL isCameraOn;

/// 是否打开麦克风。默认打开
@property(nonatomic, assign) BOOL isMicOn;

/// 是否打开扬声器。默认打开
@property(nonatomic, assign) BOOL isSpkOn;

/// 是否离线入会
@property(nonatomic, assign) BOOL isOfflineJoin;

/// 会议id
@property (nonatomic, copy) NSString *confId;

/// 三方自定义字段
@property (nonatomic, copy) NSString *extendedField;

@end

NS_ASSUME_NONNULL_END
