//
//  HWMIncomingCallAnswerViewController.m
//  HWMUISDKNativeDemo
//
//  Created by chenlinfeng on 2021/1/6.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMIncomingCallAnswerViewController.h"
#import "HWMInputView.h"
#import "HWMSwitchCell.h"
#import <HWMUISDK/HWMUISDK.h>

typedef NS_ENUM (NSInteger, HWMIncomingCallSwitchCellType) {
    HWMIncomingCallSwitchInject = 0,
    HWMIncomingCallSwitchAudioAccept,
};

@interface HWMIncomingCallAnswerViewController () <HWMSwitchCellDelegate, HWMIncomingAnswerHandler>

@property (nonatomic, strong) HWMSwitchCell *injectSwitchCell;
@property (nonatomic, assign) BOOL injectSwitchState;
@property (nonatomic, strong) NSPopUpButton *answerTypeBtn;
@property (nonatomic, assign) HWMIncomingAnswerType answerType;
@property (nonatomic, strong) HWMSwitchCell *audioAcceptSwitchCell;
@property (nonatomic, assign) BOOL audioAcceptSwitchState;
@property (nonatomic, strong) NSButton *rejectBtn;
@property (nonatomic, strong) NSButton *acceptBtn;
@property (nonatomic, strong) HWMInputView *audioFileInputView;
@property (nonatomic, strong) HWMInputView *loopTimesInputView;
@property (nonatomic, strong) NSButton *startPlayAudioFileBtn;
@property (nonatomic, strong) NSButton *stopPlayAudioFileBtn;

@end

@implementation HWMIncomingCallAnswerViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

#pragma mark - UI

- (void)setupUI {
    [self.view addSubview:self.injectSwitchCell];
    [self.injectSwitchCell mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(50);
        make.centerX.mas_equalTo(0);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(540);
    }];
    
    [self.view addSubview:self.answerTypeBtn];
    [self.answerTypeBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.injectSwitchCell.mas_bottom);
        make.centerX.mas_equalTo(0);
        make.height.mas_equalTo(30);
        make.width.mas_equalTo(300);
    }];
    
    [self.view addSubview:self.audioAcceptSwitchCell];
    [self.audioAcceptSwitchCell mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.answerTypeBtn.mas_bottom);
        make.centerX.mas_equalTo(0);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(540);
    }];
    
    [self.view addSubview:self.rejectBtn];
    [self.rejectBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.audioAcceptSwitchCell.mas_bottom).offset(10);
        make.centerX.mas_equalTo(-80);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(140);
    }];
    
    [self.view addSubview:self.acceptBtn];
    [self.acceptBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.audioAcceptSwitchCell.mas_bottom).offset(10);
        make.centerX.mas_equalTo(80);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(140);
    }];
    
    [self.view addSubview:self.audioFileInputView];
    [self.audioFileInputView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(260);
        make.centerX.mas_equalTo(0);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(300);
    }];
    
    [self.view addSubview:self.loopTimesInputView];
    [self.loopTimesInputView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.audioFileInputView.mas_bottom);
        make.centerX.mas_equalTo(0);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(300);
    }];
    
    [self.view addSubview:self.startPlayAudioFileBtn];
    [self.startPlayAudioFileBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.loopTimesInputView.mas_bottom).offset(10);
        make.centerX.mas_equalTo(-80);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(140);
    }];
    
    [self.view addSubview:self.stopPlayAudioFileBtn];
    [self.stopPlayAudioFileBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.loopTimesInputView.mas_bottom).offset(10);
        make.centerX.mas_equalTo(80);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(140);
    }];
}

#pragma mark - HWMSwitchCellDelegate

- (void)switchStateChanged:(BOOL)state index:(NSInteger)index {
    switch (index) {
        case HWMIncomingCallSwitchInject: {
            self.injectSwitchState = state;
            [HWMSdk getSdkConfig].incomingAnswerHandler = state ? self : nil;
        }
            break;
        case HWMIncomingCallSwitchAudioAccept:
            self.audioAcceptSwitchState = state;
            break;
        default:
            break;
    }
}

#pragma mark - HWMIncomingAnswerHandler

- (HWMIncomingAnswerType)answerTypeOnCallIncoming {
    return self.answerType;
}

- (HWMIncomingAnswerType)answerTypeOnConfIncoming {
    return self.answerType;
}

#pragma mark - Event

- (void)answerTypeBtnAction:(NSPopUpButton *)sender {
    self.answerType = (HWMIncomingAnswerType)sender.indexOfSelectedItem;
}

- (void)rejectBtnClick {
    [[HWMSdk getOpenApi] rejectConfWithCallback:^(NSError * _Nullable error, id  _Nullable result) {
        if (error) {
            [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"reject conf failed, error code: %ld", error.code];
        } else {
            [HWMConsoleManager shareInstance].console = @"reject conf success";
        }
    }];
}

- (void)acceptBtnClick {
    HWMUISDKAcceptConfParamModel *model = [[HWMUISDKAcceptConfParamModel alloc] init];
    model.isAudioAccept = self.audioAcceptSwitchState;
    [[HWMSdk getOpenApi] acceptConfWithParam:model callback:^(NSError * _Nullable error, id  _Nullable result) {
        if (error) {
            [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"accept conf failed, error code: %ld", error.code];
        } else {
            [HWMConsoleManager shareInstance].console = @"accept conf success";
        }
    }];
}

- (void)startPlayAudioFileBtnClick {
    HWMUISDKStartPlayAudioFileParamModel *model = [[HWMUISDKStartPlayAudioFileParamModel alloc] init];
    model.loopTimes = [self.loopTimesInputView.textField.stringValue integerValue];
    model.filePath = self.audioFileInputView.textField.stringValue;
    [[HWMSdk getPrivateApi] startPlayAudioFileWithParam:model callback:^(NSError * _Nullable error, id  _Nullable result) {
        if (error) {
            [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"start play audio file failed, error code: %ld", error.code];
        } else {
            [HWMConsoleManager shareInstance].console = @"start play audio file success";
        }
    }];
}

- (void)stopPlayAudioFileBtnClick {
    HWMSDKERR result = [[HWMSdk getPrivateApi] stopPlayAudioFile];
    if (result != HWMSDKSdkerrSuccess) {
        [HWMConsoleManager shareInstance].console = @"stop play audio file failed";
    } else {
        [HWMConsoleManager shareInstance].console = @"stop play audio file success";
    }
}

#pragma mark - Lazy

- (HWMSwitchCell *)injectSwitchCell {
    if (!_injectSwitchCell) {
        _injectSwitchCell = [[HWMSwitchCell alloc] init];
        _injectSwitchCell.title = @"是否注入来电接听策略";
        _injectSwitchCell.delegate = self;
        _injectSwitchCell.state = self.injectSwitchState;
        _injectSwitchCell.index = HWMIncomingCallSwitchInject;
    }
    return _injectSwitchCell;
}

- (NSPopUpButton *)answerTypeBtn {
    if (!_answerTypeBtn) {
        _answerTypeBtn = [[NSPopUpButton alloc] init];
        _answerTypeBtn.target = self;
        _answerTypeBtn.action = @selector(answerTypeBtnAction:);
        [_answerTypeBtn addItemsWithTitles:@[@"原始体验", @"自动拒接", @"自动接听", @"自定义弹框"]];
    }
    return _answerTypeBtn;
}

- (HWMSwitchCell *)audioAcceptSwitchCell {
    if (!_audioAcceptSwitchCell) {
        _audioAcceptSwitchCell = [[HWMSwitchCell alloc] init];
        _audioAcceptSwitchCell.title = @"是否语音接听（仅点对点视频会议生效）";
        _audioAcceptSwitchCell.delegate = self;
        _audioAcceptSwitchCell.state = self.audioAcceptSwitchState;
        _audioAcceptSwitchCell.index = HWMIncomingCallSwitchAudioAccept;
    }
    return _audioAcceptSwitchCell;
}

- (NSButton *)rejectBtn {
    if (!_rejectBtn) {
        _rejectBtn = [NSButton buttonWithTitle:@"拒接" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(rejectBtnClick)];
        _rejectBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _rejectBtn.layer.cornerRadius = 4.0;
        _rejectBtn.layer.masksToBounds = YES;
    }
    return _rejectBtn;
}

- (NSButton *)acceptBtn {
    if (!_acceptBtn) {
        _acceptBtn = [NSButton buttonWithTitle:@"接听" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(acceptBtnClick)];
        _acceptBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _acceptBtn.layer.cornerRadius = 4.0;
        _acceptBtn.layer.masksToBounds = YES;
    }
    return _acceptBtn;
}

- (HWMInputView *)audioFileInputView {
    if (!_audioFileInputView) {
        _audioFileInputView = [[HWMInputView alloc] init];
        _audioFileInputView.title = @"音频文件路径";
        _audioFileInputView.placeholder = @"仅支持wav格式";
    }
    return _audioFileInputView;
}

- (HWMInputView *)loopTimesInputView {
    if (!_loopTimesInputView) {
        _loopTimesInputView = [[HWMInputView alloc] init];
        _loopTimesInputView.title = @"循环次数";
        _loopTimesInputView.placeholder = @"0代表无限循环";
    }
    return _loopTimesInputView;
}

- (NSButton *)startPlayAudioFileBtn {
    if (!_startPlayAudioFileBtn) {
        _startPlayAudioFileBtn = [NSButton buttonWithTitle:@"开始播放音频文件" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(startPlayAudioFileBtnClick)];
        _startPlayAudioFileBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _startPlayAudioFileBtn.layer.cornerRadius = 4.0;
        _startPlayAudioFileBtn.layer.masksToBounds = YES;
    }
    return _startPlayAudioFileBtn;
}

- (NSButton *)stopPlayAudioFileBtn {
    if (!_stopPlayAudioFileBtn) {
        _stopPlayAudioFileBtn = [NSButton buttonWithTitle:@"停止播放音频文件" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(stopPlayAudioFileBtnClick)];
        _stopPlayAudioFileBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _stopPlayAudioFileBtn.layer.cornerRadius = 4.0;
        _stopPlayAudioFileBtn.layer.masksToBounds = YES;
    }
    return _stopPlayAudioFileBtn;
}

@end
