//
//  HWMInterruptShareController.m
//  HWMUISDKNativeDemo
//
//  Created by linweiqiang on 2025/2/14.
//  Copyright © 2025 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMInterruptShareController.h"
#import "HWMSwitchCell.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMInterruptShareController () <HWMSwitchCellDelegate, HWMShareInterceptHandler>

@property (nonatomic, strong) HWMSwitchCell *switchCell;
@property (nonatomic, strong) NSButton *selfShareStateBtn;
@property (nonatomic, strong) NSButton *stopShareBtn;
@property (nonatomic, assign) BOOL switchState;

@end

@implementation HWMInterruptShareController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
    [HWMSdk getSdkConfig].shareInterceptHandler = self;
}

#pragma mark - HWMInterruptShareHandler

- (void)onSelfStartShareIntercept:(void (^)(HWMShareInterceptInfo * _Nonnull))completionBlock {
    HWMShareInterceptInfo *model = [[HWMShareInterceptInfo alloc] init];
    model.isInterrupt = self.switchState;
    completionBlock(model);
    if (self.switchCell) {
        [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"已拦截共享"];
    }
}

#pragma mark - UI

- (void)setupUI {
    [self.view addSubview:self.switchCell];
    [self.switchCell mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(100);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(600);
    }];
    
    [self.view addSubview:self.stopShareBtn];
    [self.stopShareBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.bottom.equalTo(self.view.mas_bottom).offset(-100);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
    
    [self.view addSubview:self.selfShareStateBtn];
    [self.selfShareStateBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.bottom.equalTo(self.stopShareBtn.mas_top).offset(-20);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

#pragma mark - HWMSwitchCellDelegate

- (void)switchStateChanged:(BOOL)state index:(NSInteger)index {
    self.switchState = state;
}

#pragma mark - Event

- (void)stopShare {
    [[HWMBizSdk getBizOpenApi] stopShare:@""];
}

- (void)selfShareState {
    BOOL isSharing = [[HWMBizSdk getBizOpenApi] getSelfShareState];
    [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"查询自己共享状态: %@", isSharing ? @"正在共享" : @"不在共享"];
}

#pragma mark - Lazy

- (HWMSwitchCell *)switchCell {
    if (!_switchCell) {
        _switchCell = [[HWMSwitchCell alloc] init];
        _switchCell.title = @"开启拦截共享";
        _switchCell.delegate = self;
        _switchCell.state = self.switchState;
    }
    return _switchCell;
}

- (NSButton *)selfShareStateBtn {
    if (!_selfShareStateBtn) {
        _selfShareStateBtn = [NSButton buttonWithTitle:@"查询自己共享状态" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(selfShareState)];
        _selfShareStateBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _selfShareStateBtn.layer.cornerRadius = 4.0;
        _selfShareStateBtn.layer.masksToBounds = YES;
    }
    return _selfShareStateBtn;
}

- (NSButton *)stopShareBtn {
    if (!_stopShareBtn) {
        _stopShareBtn = [NSButton buttonWithTitle:@"停止共享" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(stopShare)];
        _stopShareBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _stopShareBtn.layer.cornerRadius = 4.0;
        _stopShareBtn.layer.masksToBounds = YES;
    }
    return _stopShareBtn;
}

@end
