//
//  HWMStartP2PConfController.m
//  HWMUISDKNativeDemo
//
//  Created by linweiqiang on 2023/6/8.
//  Copyright © 2023 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMStartP2PConfController.h"
#import "HWMSDKTableView.h"
#import "HWMInputInfoTitleCell.h"
#import "HWMJoinConfLimitCell.h"
#import "HWMSwitchCell.h"
#import <HWMUISDK/HWMUISDK.h>

typedef NS_ENUM (NSInteger, HWMBookConfCellType) {
    HWMStartP2PCellTypeCallerName = 0,      // 呼叫人的Name
    HWMStartP2PCellTypeCallerAliasCN,       // 呼叫人的AliasCN
    HWMStartP2PCellTypeCallerAliasEN,       // 呼叫人的AliasEN
    HWMStartP2PCellTypeCallerExtendedField, // 呼叫人的ExtendedField
    HWMStartP2PCellTypeCalleeNumber,        // 被叫人的Number
    HWMStartP2PCellTypeCalleeThirdUserId,   // 被叫人的ThirdUserId
    HWMStartP2PCellTypeCalleeName,          // 被叫人的Name
    HWMStartP2PCellTypeCalleeAliasCN,       // 被叫人的AliasCN
    HWMStartP2PCellTypeCalleeAliasEN,       // 被叫人的AliasEN
    HWMStartP2PCellTypeCalleeExtendedField, // 被叫人的ExtendedField
    HWMStartP2PCellTypeCalleeCorpId,        // 被叫人的CorpId
    HWMStartP2PCellTypeCustomInfo,          // 自定义参数
    HWMStartP2PCellTypeVideo,               // 是否视频呼叫
    HWMStartP2PCellTypeNeedPassword,        // 是否设置来宾密码
    HWMStartP2PCellTypeAllowJoin            // 允许入会范围
};

@interface HWMStartP2PConfController () <HWMSDKTableViewDataSourse, HWMSDKTableViewDelegate, HWMInputInfoTitleCellDelegate, HWMSwitchCellDelegate>

@property (nonatomic, strong) HWMSDKTableView *listView;
@property (nonatomic, strong) NSButton *startP2PConfBtn;
@property (nonatomic, strong) HWMUISDKStartCallInfoModel *startCallInfo;

/// 标题
@property (nonatomic, copy) NSDictionary<NSNumber *, NSString *> *titleDic;

@end

@implementation HWMStartP2PConfController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupData];
    [self setupUI];
}

- (void)setupData {
    self.titleDic = @{
        @(HWMStartP2PCellTypeCallerName) : @"呼叫人的Name",
        @(HWMStartP2PCellTypeCallerAliasCN) : @"呼叫人的AliasCN",
        @(HWMStartP2PCellTypeCallerAliasEN) : @"呼叫人的AliasEN",
        @(HWMStartP2PCellTypeCallerExtendedField) : @"呼叫人的ExtendedField",
        @(HWMStartP2PCellTypeCalleeNumber) : @"被叫人的Number",
        @(HWMStartP2PCellTypeCalleeThirdUserId) : @"被叫人的ThirdUserId",
        @(HWMStartP2PCellTypeCalleeName) : @"被叫人的Name",
        @(HWMStartP2PCellTypeCalleeAliasCN) : @"被叫人的AliasCN",
        @(HWMStartP2PCellTypeCalleeAliasEN) : @"被叫人的AliasEN",
        @(HWMStartP2PCellTypeCalleeExtendedField) : @"被叫人的ExtendedField",
        @(HWMStartP2PCellTypeCalleeCorpId) : @"被叫人的CorpId",
        @(HWMStartP2PCellTypeCustomInfo) : @"自定义字段customInfo",
        @(HWMStartP2PCellTypeVideo) : @"是否视频呼叫",
        @(HWMStartP2PCellTypeNeedPassword) : @"是否设置来宾密码",
        @(HWMStartP2PCellTypeAllowJoin) : @"允许入会范围"
    };
}

- (void)setupUI {
    self.startP2PConfBtn = [NSButton buttonWithTitle:@"开始立即会议" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(click)];
    self.startP2PConfBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
    self.startP2PConfBtn.layer.cornerRadius = 4.0;
    self.startP2PConfBtn.layer.masksToBounds = YES;
    [self.view addSubview:self.startP2PConfBtn];
    [self.startP2PConfBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.bottom.mas_equalTo(-65);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];

    self.listView = [[HWMSDKTableView alloc] initTableViewClomuIdentifier:@"startP2PConf"];
    self.listView.delegate = self;
    self.listView.dataSource = self;
    [self.view addSubview:self.listView];
    [self.listView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(65);
        make.leading.mas_equalTo(15);
        make.trailing.mas_equalTo(-15);
        make.bottom.mas_equalTo(self.startP2PConfBtn.mas_top).offset(-20);
    }];
}

#pragma mark - HWMSDKTableView

- (NSInteger)numberOfRowsInTableView:(NSTableView *)tableView {
    return self.titleDic.count;
}

- (NSView *)tableView:(NSTableView *)tableView viewForTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row {
    if (row == HWMStartP2PCellTypeCallerName ||
        row == HWMStartP2PCellTypeCallerAliasCN ||
        row == HWMStartP2PCellTypeCallerAliasEN ||
        row == HWMStartP2PCellTypeCallerExtendedField ||
        row == HWMStartP2PCellTypeCalleeNumber ||
        row == HWMStartP2PCellTypeCalleeThirdUserId ||
        row == HWMStartP2PCellTypeCalleeName ||
        row == HWMStartP2PCellTypeCalleeAliasCN ||
        row == HWMStartP2PCellTypeCalleeAliasEN ||
        row == HWMStartP2PCellTypeCalleeExtendedField ||
        row == HWMStartP2PCellTypeCalleeCorpId ||
        row == HWMStartP2PCellTypeCustomInfo) {
        HWMInputInfoTitleCell *cell = [HWMInputInfoTitleCell inputInfoTitleCell:tableView ower:self];
        cell.delegate = self;
        cell.index = row;
        cell.title = self.titleDic[@(row)];
        cell.content = [self contentForCell:row];
        return cell;
    } else if (row == HWMStartP2PCellTypeVideo ||
               row == HWMStartP2PCellTypeNeedPassword) {
        HWMSwitchCell *cell = [HWMSwitchCell initSwitchCell:tableView ower:self];
        cell.index = row;
        cell.delegate = self;
        cell.title = self.titleDic[@(row)];
        if (row == HWMStartP2PCellTypeVideo) {
            cell.state = self.startCallInfo.mediaType == HWMUISDKMediaTypeVideo;
        } else {
            cell.state = !self.startCallInfo.isGuestJoinConfWithoutPwd;
        }
        return cell;
    } else {
        HWMJoinConfLimitCell *cell = [HWMJoinConfLimitCell joinConfLimitCell:tableView ower:self];
        cell.title = self.titleDic[@(row)];
        cell.menuTitles = @[@"所有人", @"仅企业内人员", @"仅会议邀请人员"];
        cell.enable = YES;
        cell.currentIndex = self.startCallInfo.confAllowJoinUser > 0 ? self.startCallInfo.confAllowJoinUser - 1 : 0;
        @weakify(self)
        [cell setSelectMenuItemHandler:^(NSInteger index,NSString *_Nullable title) {
            @strongify(self)
            self.startCallInfo.confAllowJoinUser = index > 0 ? index + 1 : 0;
        }];
        return cell;
    }
}

- (CGFloat)tableView:(NSTableView *)tableView heightOfRow:(NSInteger)row {
    return 40.0;
}

- (NSString *)contentForCell:(NSInteger)index {
    if (index == HWMStartP2PCellTypeCallerName) {
        return self.startCallInfo.callerInfo.nickName;
    } else if (index == HWMStartP2PCellTypeCallerAliasCN) {
        return self.startCallInfo.callerInfo.aliasCN;
    } else if (index == HWMStartP2PCellTypeCallerAliasEN) {
        return self.startCallInfo.callerInfo.aliasEN;
    } else if (index == HWMStartP2PCellTypeCallerExtendedField) {
        return self.startCallInfo.callerInfo.extendedField;
    } else if (index == HWMStartP2PCellTypeCalleeNumber) {
        return self.startCallInfo.calleeInfo.number;
    } else if (index == HWMStartP2PCellTypeCalleeThirdUserId) {
        return self.startCallInfo.calleeInfo.thirdUserId;
    } else if (index == HWMStartP2PCellTypeCalleeName) {
        return self.startCallInfo.calleeInfo.nickName;
    } else if (index == HWMStartP2PCellTypeCalleeAliasCN) {
        return self.startCallInfo.calleeInfo.aliasCN;
    } else if (index == HWMStartP2PCellTypeCalleeAliasEN) {
        return self.startCallInfo.calleeInfo.aliasEN;
    } else if (index == HWMStartP2PCellTypeCalleeExtendedField) {
        return self.startCallInfo.calleeInfo.extendedField;
    } else if (index == HWMStartP2PCellTypeCalleeCorpId) {
        return self.startCallInfo.calleeInfo.corpId;
    } else if (index == HWMStartP2PCellTypeCustomInfo) {
        return self.startCallInfo.customInfo;
    }
    return @"";
}
#pragma mark - HWMInputInfoTitleCellDelegate

- (void)inputInfoCellDidEdite:(NSString *)content index:(NSInteger)index {
    if (index == HWMStartP2PCellTypeCallerName) {
        self.startCallInfo.callerInfo.nickName = content;
    } else if (index == HWMStartP2PCellTypeCallerAliasCN) {
        self.startCallInfo.callerInfo.aliasCN = content;
    } else if (index == HWMStartP2PCellTypeCallerAliasEN) {
        self.startCallInfo.callerInfo.aliasEN = content;
    } else if (index == HWMStartP2PCellTypeCallerExtendedField) {
        self.startCallInfo.callerInfo.extendedField = content;
    } else if (index == HWMStartP2PCellTypeCalleeNumber) {
        self.startCallInfo.calleeInfo.number = content;
    } else if (index == HWMStartP2PCellTypeCalleeThirdUserId) {
        self.startCallInfo.calleeInfo.thirdUserId = content;
    } else if (index == HWMStartP2PCellTypeCalleeName) {
        self.startCallInfo.calleeInfo.nickName = content;
    } else if (index == HWMStartP2PCellTypeCalleeAliasCN) {
        self.startCallInfo.calleeInfo.aliasCN = content;
    } else if (index == HWMStartP2PCellTypeCalleeAliasEN) {
        self.startCallInfo.calleeInfo.aliasEN = content;
    } else if (index == HWMStartP2PCellTypeCalleeExtendedField) {
        self.startCallInfo.calleeInfo.extendedField = content;
    } else if (index == HWMStartP2PCellTypeCalleeCorpId) {
        self.startCallInfo.calleeInfo.corpId = content;
    } else if (index == HWMStartP2PCellTypeCustomInfo) {
        self.startCallInfo.customInfo = content;
    }
}

#pragma mark - HWMSwitchCellDelegate

- (void)switchStateChanged:(BOOL)state index:(NSInteger)index {
    if (index == HWMStartP2PCellTypeVideo) {
        self.startCallInfo.mediaType = state ? HWMUISDKMediaTypeVideo : HWMUISDKMediaTypeAudio;
    } else if (index == HWMStartP2PCellTypeNeedPassword) {
        self.startCallInfo.isGuestJoinConfWithoutPwd = !state;
    }
}

- (HWMUISDKStartCallInfoModel *)startCallInfo {
    if (!_startCallInfo) {
        _startCallInfo = [[HWMUISDKStartCallInfoModel alloc] init];
        _startCallInfo.callerInfo = [[HWMUISDKCallerInfoModel alloc] init];
        _startCallInfo.calleeInfo = [[HWMUISDKCalleeInfoModel alloc] init];
        _startCallInfo.mediaType = HWMUISDKMediaTypeVideo;
    }
    return _startCallInfo;
}

- (void)click {
    if (![HWMSdk hasInit]) {
        [HWMConsoleManager shareInstance].console = @"no init";
        return;
    }

    if (self.startCallInfo.calleeInfo.number.length == 0 && self.startCallInfo.calleeInfo.thirdUserId.length == 0) {
        [HWMConsoleManager shareInstance].console = @"number and thirdUserId can not be nil";
        return;
    }

    if (self.startCallInfo.calleeInfo.nickName.length == 0) {
        [HWMConsoleManager shareInstance].console = @"name can not be nil";
        return;
    }

    [[HWMSdk getOpenApi] startP2PConf:self.startCallInfo callback:^(NSError * _Nullable error, HWMCreateConfResult * _Nullable result) {
        if (error) {
            [HWMConsoleManager shareInstance].error = error;
        } else {
            [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"%@", [result yy_modelDescription]];
        }
    }];
}

@end
