//
//  HWME2EEHandlerImpl.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2022/3/4.
//  Copyright © 2022 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWME2EEHandlerImpl.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWME2EEHandlerImpl ()<HWME2EENotifyHandler>

@end

@implementation HWME2EEHandlerImpl

+ (instancetype)shareInstance {
    static id instance;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        instance = [[self alloc] init];
    });
    return instance;
}

- (instancetype)init {
    self = [super init];
    if (self) {
        [[HWMSDKE2eeAdapater shareInstance] addE2EENotifyCallback:self];
    }
    return self;
}

- (NSData *)onE2EEAudioDecryptNotify:(NSData *)buffer {
    NSData *originalData = [[NSData alloc] initWithBase64EncodedData:buffer options:0];
    return originalData;
}

- (NSData *)onE2EEAudioEncryptNotify:(NSData *)buffer {
    NSData *base64Data = [buffer base64EncodedDataWithOptions:0];
    return base64Data;
}

- (NSData *)onE2EEVideoDecryptNotify:(NSData *)buffer {
    NSData *originalData = [[NSData alloc] initWithBase64EncodedData:buffer options:0];
    return originalData;
}

- (NSData *)onE2EEVideoEncryptNotify:(NSData *)buffer {
    NSData *base64Data = [buffer base64EncodedDataWithOptions:0];
    return base64Data;
}

@end
