//
//  HWMItemConfigModel.h
//  HWMUISDKNativeDemo
//
//  Created by tyfinal on 2021/6/30.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <HWMUISDK/HWMToolBarItemModel.h>
#import <HWMUISDK/HWMMenuItemModel.h>

NS_ASSUME_NONNULL_BEGIN
@class HWMItemConfigSubmodel;
@class HWMMenuConfigSubmodel;
@interface HWMItemConfigModel : NSObject
@property (nonatomic, copy) NSArray <NSArray <HWMToolBarItemModel *> *> *toolBar;
@property (nonatomic, copy) NSArray *shareBar;
@property (nonatomic, copy) NSArray *toolBarMore;
@property (nonatomic, copy) NSArray *shareBarMore;

@end

@interface HWMItemConfigSubmodel : NSObject
@property (nonatomic, copy) NSString *title;
@property (nonatomic, copy) NSString *type;
@property (nonatomic, copy) NSString *defaultConfig;
@property (nonatomic, copy) NSString *useCustomEvent;
@property (nonatomic, copy) NSString *useDefaultConfig;
@property (nonatomic, copy, nullable) NSString *selectedTitle;
@property (nonatomic, copy, nullable) NSString *disabledTitle;
/// 初始展示的按钮标题
@property (nonatomic, copy) NSString *defaultTitle;

/// 普通状态下的按钮图标
@property (nonatomic, copy) NSString *imagePath;
/// 按钮选中时的图标  不设置则与正常状态下一致
@property (nonatomic, copy, nullable) NSString *selectedImagePath;
/// 按钮不可操作时的标题文字颜色 不设置则默认为系统置灰
@property (nonatomic, strong, nullable) NSString *disabledImagePath;
/// 初始展示的图片
@property (nonatomic, copy) NSString *defaultImagePath;
/// 功能锁定时展示的图片 (如 共享 聊天 与会者)
@property (nonatomic, copy) NSString *lockImagePath;
/// 初始选中状态 默认为NO
@property (nonatomic, assign) BOOL selected;
///
@property (nonatomic, copy,nullable) NSArray *submenus;

@end

@interface HWMMenuConfigSubmodel : NSObject
@property (nonatomic, copy) NSString *title;
@property (nonatomic, copy) NSString *defaultConfig;
@property (nonatomic, copy) NSString *useCustomEvent;
@property (nonatomic, copy) NSString *useDefaultConfig;
@property (nonatomic, copy) NSArray *submenus;
@property (nonatomic, assign) BOOL allowSelected;
@property (nonatomic, assign) BOOL selected;
@property (nonatomic, copy, nullable) NSString *imagePath;
@property (nonatomic, copy, nullable) NSString *selectedImagePath;
@property (nonatomic, assign) BOOL needSeperator;
@property (nonatomic, assign) NSInteger themeLevel;

@end

NS_ASSUME_NONNULL_END
