//
//  HWMItemConfigModel.m
//  HWMUISDKNativeDemo
//
//  Created by tyfinal on 2021/6/30.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMItemConfigModel.h"
#import <OpenSourceIntegration/YYModel.h>
#import <HWMUISDK/HWMMenuItemModel.h>

@implementation HWMItemConfigModel
- (BOOL)modelCustomTransformFromDictionary:(NSDictionary *)dic {
    if (dic[@"toolBar"] && [dic[@"toolBar"] count] > 0) {
        NSMutableArray *mu = @[].mutableCopy;
        NSArray *temArr;
        for (NSArray *arr in dic[@"toolBar"]) {
            temArr = [NSArray yy_modelArrayWithClass:[HWMItemConfigSubmodel class] json:arr];
            [mu addObject:temArr];
        }
        _toolBar = mu.copy;
        return YES;
    }
    return NO;
}

+ (nullable NSDictionary<NSString *, id> *)modelContainerPropertyGenericClass {
    return @{ @"shareBar": [HWMItemConfigSubmodel class],
              @"toolBarMore": [HWMMenuConfigSubmodel class],
              @"shareBarMore": [HWMMenuConfigSubmodel class] };
}

@end

@implementation HWMItemConfigSubmodel

+ (nullable NSDictionary<NSString *, id> *)modelContainerPropertyGenericClass {
    return @{ @"submenus": [HWMMenuConfigSubmodel class] };
}

@end

@implementation HWMMenuConfigSubmodel
+ (nullable NSDictionary<NSString *, id> *)modelContainerPropertyGenericClass {
    return @{ @"submenus": [HWMMenuConfigSubmodel class] };
}

@end
