//
//  HWMBookCycleTypeCell.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2021/10/19.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMBookCycleTypeCell.h"

@interface HWMBookCycleTypeCell ()

/// 天
@property (nonatomic, strong) NSButton *dayBtn;
/// 周
@property (nonatomic, strong) NSButton *weekBtn;
/// 月
@property (nonatomic, strong) NSButton *monthBtn;

@end

@implementation HWMBookCycleTypeCell

+ (instancetype)initBookCycleConfType:(NSTableView *)tableView ower:(id)ower {
    HWMBookCycleTypeCell *cell = [tableView makeViewWithIdentifier:NSStringFromClass([HWMBookCycleTypeCell class]) owner:ower];
    if (cell == nil) {
        cell = [[HWMBookCycleTypeCell alloc] initWithFrame:NSZeroRect];
        cell.identifier = NSStringFromClass([HWMBookCycleTypeCell class]);
    }
    return cell;
}

- (instancetype)initWithFrame:(NSRect)frameRect {
    if (self = [super initWithFrame:frameRect]) {
        self.wantsLayer = YES;
        self.layer.backgroundColor = [NSColor whiteColor].CGColor;
        [self setupUI];
    }
    return self;
}

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];
    
    // Drawing code here.
}

#pragma mark - UI
- (void)setupUI {
    [self addSubview:self.weekBtn];
    [self addSubview:self.dayBtn];
    [self addSubview:self.monthBtn];
    
    [self.weekBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.center.equalTo(self);
    }];
    
    [self.dayBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.trailing.equalTo(self.weekBtn.mas_leading).offset(-100);
        make.centerY.equalTo(self);
    }];
    
    [self.monthBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.weekBtn.mas_trailing).offset(100);
        make.centerY.equalTo(self);
    }];
}

#pragma mark - Event
- (void)selectCycleType:(NSButton *)sender {
    if (self.bookCycleSelectModeHandler) {
        self.bookCycleSelectModeHandler(sender.tag);
    }
}


- (void)setSelectMode:(NSInteger)selectMode {
    if (selectMode == 0) {
        self.dayBtn.state = NSControlStateValueOn;
    } else if (selectMode == 1) {
        self.weekBtn.state = NSControlStateValueOn;
    } else {
        self.monthBtn.state = NSControlStateValueOn;
    }
}

#pragma mark - Lazy

- (NSButton *)dayBtn {
    if (!_dayBtn) {
        _dayBtn = [[NSButton alloc] init];
        _dayBtn.bordered = NO;
        _dayBtn.font = [NSFont systemFontOfSize:12];
        [_dayBtn setBezelStyle:NSBezelStyleRegularSquare];
        [_dayBtn setButtonType:NSButtonTypeRadio];
        [_dayBtn setState:NSControlStateValueOff];
        [_dayBtn setTitle:@"天"];
        _dayBtn.target = self;
        _dayBtn.action = @selector(selectCycleType:);
        _dayBtn.tag = 0;
        _dayBtn.state = NSControlStateValueOn;
    }
    return _dayBtn;
}

- (NSButton *)weekBtn {
    if (!_weekBtn) {
        _weekBtn = [[NSButton alloc] init];
        _weekBtn.bordered = NO;
        _weekBtn.font = [NSFont systemFontOfSize:12];
        [_weekBtn setBezelStyle:NSBezelStyleRegularSquare];
        [_weekBtn setButtonType:NSButtonTypeRadio];
        [_weekBtn setState:NSControlStateValueOff];
        [_weekBtn setTitle:@"周"];
        _weekBtn.target = self;
        _weekBtn.action = @selector(selectCycleType:);
        _weekBtn.tag = 1;
    }
    return _weekBtn;
}

- (NSButton *)monthBtn {
    if (!_monthBtn) {
        _monthBtn = [[NSButton alloc] init];
        _monthBtn.bordered = NO;
        _monthBtn.font = [NSFont systemFontOfSize:12];
        [_monthBtn setBezelStyle:NSBezelStyleRegularSquare];
        [_monthBtn setButtonType:NSButtonTypeRadio];
        [_monthBtn setState:NSControlStateValueOff];
        [_monthBtn setTitle:@"月"];
        _monthBtn.target = self;
        _monthBtn.action = @selector(selectCycleType:);
        _monthBtn.tag = 2;
    }
    return _monthBtn;
}

@end
