//
//  HWMContentTitleViewCell.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/11/5.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMContentTitleViewCell.h"

@interface HWMContentTitleViewCell ()
/// 标题
@property (nonatomic, strong) NSTextField *titleLabel;
/// 内容
@property (nonatomic, strong) NSTextField *contentLabel;

@end

@implementation HWMContentTitleViewCell

+ (instancetype)initContentTitleCell:(NSTableView *)tableView ower:(id)ower {
    HWMContentTitleViewCell *cell = [tableView makeViewWithIdentifier:NSStringFromClass([HWMContentTitleViewCell class]) owner:ower];
    if (!cell) {
        cell = [[HWMContentTitleViewCell alloc] initWithFrame:NSZeroRect];
        cell.identifier = NSStringFromClass([HWMContentTitleViewCell class]);
    }
    return cell;
}

- (instancetype)initWithFrame:(NSRect)frameRect {
    if (self = [super initWithFrame:frameRect]) {
        self.wantsLayer = YES;
        self.layer.backgroundColor = [NSColor whiteColor].CGColor;
        [self setupUI];
    }
    return self;
}

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];

    // Drawing code here.
}

#pragma mark - UI
- (void)setupUI {
    [self addSubview:self.titleLabel];
    [self addSubview:self.contentLabel];

    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self).offset(120);
        make.centerY.equalTo(self);
        make.width.mas_equalTo(80);
    }];

    [self.contentLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.trailing.equalTo(self).offset(-120);
        make.leading.equalTo(self.titleLabel.mas_trailing).offset(10);
        make.centerY.equalTo(self);
    }];
}

- (void)setTitle:(NSString *)title {
    _title = title;
    self.titleLabel.stringValue = title;
}

- (void)setContent:(NSString *)content {
    _content = content;
    self.contentLabel.stringValue = content;
}

#pragma mark - Lazy
- (NSTextField *)titleLabel {
    if (!_titleLabel) {
        _titleLabel = [NSTextField hwm_fieldWithTitle:@"会议主题" titleColor:[NSColor colorWithRGB:0x666666] font:[NSFont systemFontOfSize:13]];
    }
    return _titleLabel;
}

- (NSTextField *)contentLabel {
    if (!_contentLabel) {
        _contentLabel = [NSTextField hwm_fieldWithTitle:@"GM的云会议" titleColor:[NSColor colorWithRGB:0x333333] font:[NSFont systemFontOfSize:13]];
    }
    return _contentLabel;
}

@end
