//
//  HWMSocialView.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/11/13.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSocialView.h"
#import "HWMSDKTableView.h"
#import "HWMConfDetailCell.h"
#import "HWMConfDetailItemModel.h"

@interface HWMSocialView ()<HWMSDKTableViewDelegate, HWMSDKTableViewDataSourse>

/// tableView
@property (nonatomic, strong) HWMSDKTableView *tableView;
/// 会议数据
@property (nonatomic, strong) NSMutableArray <HWMConfDetailItemModel *> *dataArr;

@end

@implementation HWMSocialView

- (instancetype)initWithFrame:(NSRect)frameRect {
    if (self = [super initWithFrame:frameRect]) {
        [self setupUI];
    }
    return self;
}

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];
    
}

#pragma mark - UI
- (void)setupUI {
    self.wantsLayer = YES;
    self.layer.backgroundColor = [NSColor whiteColor].CGColor;
    
    self.tableView = [[HWMSDKTableView alloc] initTableViewClomuIdentifier:@"social"];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self addSubview:self.tableView];
    
    [self.tableView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.and.top.equalTo(self).offset(10);
        make.trailing.and.bottom.equalTo(self).offset(-10);
    }];
}

- (void)setMeetingInfo:(HWMSDKMeetingInfoModel *)meetingInfo {
    [self.dataArr removeAllObjects];
    _meetingInfo = meetingInfo;
    if (meetingInfo.baseInfo.confSubject.length > 0) {
        HWMConfDetailItemModel *subModel = [[HWMConfDetailItemModel alloc] init];
        subModel.title = @"会议主题";
        subModel.content = meetingInfo.baseInfo.confSubject;
        [self.dataArr addObject:subModel];
    }
    
    if (meetingInfo.baseInfo.startTimeStamp > 0 && meetingInfo.baseInfo.endTimeStamp > 0) {
        HWMConfDetailItemModel *timeModel = [[HWMConfDetailItemModel alloc] init];
        timeModel.title = @"会议时间";
        
        NSString *startTime = [NSString timeStringFromTimeInterval:meetingInfo.baseInfo.startTimeStamp];
        NSString *endTime = [NSString timeStringFromTimeInterval:meetingInfo.baseInfo.endTimeStamp];
        timeModel.content = [NSString stringWithFormat:@"%@ - %@", startTime, endTime];
        [self.dataArr addObject:timeModel];
    }

    if (meetingInfo.baseInfo.confId.length > 0 || meetingInfo.baseInfo.vmrConfId.length > 0) {
        HWMConfDetailItemModel *idModel = [[HWMConfDetailItemModel alloc] init];
        idModel.title = @"会议ID";
        idModel.content = meetingInfo.baseInfo.vmrConfId.length > 0 ? meetingInfo.baseInfo.vmrConfId : meetingInfo.baseInfo.confId;
        [self.dataArr addObject:idModel];
    }
   
    if (meetingInfo.baseInfo.hostPwd.length > 0 && meetingInfo.baseInfo.selfConfRole == HWMConfRoleHost) {
        HWMConfDetailItemModel *hostModel = [[HWMConfDetailItemModel alloc] init];
        hostModel.title = @"主持人密码";
        hostModel.content = meetingInfo.baseInfo.hostPwd;
        [self.dataArr addObject:hostModel];
    }
    
    if (meetingInfo.baseInfo.guestPwd.length > 0) {
        HWMConfDetailItemModel *guestModel = [[HWMConfDetailItemModel alloc] init];
        guestModel.title = @"来宾密码";
        guestModel.content = meetingInfo.baseInfo.guestPwd;
        [self.dataArr addObject:guestModel];
    }
   
    HWMConfDetailItemModel *typeModel = [[HWMConfDetailItemModel alloc] init];
    typeModel.title = @"会议类型";
    typeModel.content = meetingInfo.baseInfo.mediaType == HWMConfMediaTypeVideo ? @"视频会议" : @"音频会议";
    [self.dataArr addObject:typeModel];

    HWMConfDetailItemModel *orderModel = [[HWMConfDetailItemModel alloc] init];
    orderModel.title = @"会议预订人";
    orderModel.content = meetingInfo.baseInfo.scheduserName.length > 0 ? meetingInfo.baseInfo.scheduserName : @"-";
    [self.dataArr addObject:orderModel];
    
    [self.tableView reloadData];
}

#pragma mark - Delegate

- (NSInteger)numberOfRowsInTableView:(NSTableView *)tableView {
    return self.dataArr.count;
}

- (NSView *)tableView:(NSTableView *)tableView viewForTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row {
    HWMConfDetailCell *cell = [HWMConfDetailCell confDetailCell:tableView ower:self];
    cell.model = self.dataArr[row];
    return cell;
}

- (CGFloat)tableView:(NSTableView *)tableView heightOfRow:(NSInteger)row {
    return 45.0;
}

- (NSMutableArray<HWMConfDetailItemModel *> *)dataArr {
    if (!_dataArr) {
        _dataArr = [NSMutableArray array];
    }
    return _dataArr;
}

@end
