//
//  HWMInputInfoTitleCell.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/27.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMInputInfoTitleCell.h"
#import "HWMTextField.h"

@interface HWMInputInfoTitleCell ()<NSTextFieldDelegate>
/// 标题
@property (nonatomic, strong) NSTextField *titleLabel;
/// 输入框
@property (nonatomic, strong) HWMTextField *inputField;
/// 分割线
@property (nonatomic, strong) NSView *sepLine;

@end

@implementation HWMInputInfoTitleCell

+ (instancetype)inputInfoTitleCell:(NSTableView *)tableView ower:(id)ower {
    HWMInputInfoTitleCell *cell = [tableView makeViewWithIdentifier:NSStringFromClass([HWMInputInfoTitleCell class]) owner:ower];
    if (cell == nil) {
        cell = [[HWMInputInfoTitleCell alloc] initWithFrame:NSZeroRect];
    }
    return cell;
}

- (instancetype)initWithFrame:(NSRect)frameRect {
    if (self = [super initWithFrame:frameRect]) {
        self.wantsLayer = YES;
        self.layer.backgroundColor = [NSColor whiteColor].CGColor;
        self.enabled = YES;
        self.formatterStyle = HWMFormatterStyleAll;
        [self setupUI];
    }
    return self;
}

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];
}

#pragma mark - UI
- (void)setupUI {
    [self addSubview:self.titleLabel];
    [self addSubview:self.inputField];
    [self addSubview:self.sepLine];

    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self).offset(120);
        make.centerY.equalTo(self);
        make.width.mas_greaterThanOrEqualTo(80);
    }];
    [self.inputField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.titleLabel.mas_trailing).offset(10);
        make.trailing.equalTo(self).offset(-120);
        make.centerY.equalTo(self);
    }];
    [self.sepLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.inputField.mas_leading);
        make.trailing.equalTo(self.inputField.mas_trailing);
        make.top.equalTo(self.inputField.mas_bottom).offset(10);
        make.height.mas_equalTo(1);
    }];
}

- (void)setModel:(HWMLoginInputInfoModel *)model {
    _model = model;
    self.titleLabel.stringValue = model.title;
    self.inputField.stringValue = model.content;
    self.inputField.placeholderString = model.placeholder;
}

- (void)setTitle:(NSString *)title {
    _title = title;
    self.titleLabel.stringValue = title;
}

- (void)setPlaceholder:(NSString *)placeholder {
    _placeholder = placeholder;
    self.inputField.placeholderString = placeholder;
}

- (void)setContent:(NSString *)content {
    _content = content;
    self.inputField.stringValue = content.length > 0 ? content : @"";
}

- (void)setFormatterStyle:(HWMFormatterStyle)formatterStyle {
    _formatterStyle = formatterStyle;
    HWMFormatter *formatter = [[HWMFormatter alloc] init];
    formatter.formatterStyle = formatterStyle;
    self.inputField.formatter = formatter;
}

#pragma mark - Delegate
- (void)controlTextDidChange:(NSNotification *)obj {
    NSTextField *field = obj.object;
    self.model.content = field.stringValue;
    if (self.delegate && [self.delegate respondsToSelector:@selector(inputInfoCellDidEdite:index:)]) {
        [self.delegate inputInfoCellDidEdite:field.stringValue index:self.index];
    }
}

#pragma mark - Lazy
- (NSTextField *)titleLabel {
    if (!_titleLabel) {
        _titleLabel = [NSTextField hwm_fieldWithTitle:@"APPID" titleColor:[NSColor colorWithRGB:0x666666] font:[NSFont systemFontOfSize:13]];
    }
    return _titleLabel;
}

- (HWMTextField *)inputField {
    if (!_inputField) {
        _inputField = [[HWMTextField alloc] init];
        _inputField.delegate = self;
    }
    return _inputField;
}

- (NSView *)sepLine {
    if (!_sepLine) {
        _sepLine = [[NSView alloc] init];
        _sepLine.wantsLayer = YES;
        _sepLine.layer.backgroundColor = [NSColor colorWithRGB:0xDDDDDD].CGColor;
    }
    return _sepLine;
}

- (void)setEnabled:(BOOL)enabled {
    self.inputField.enabled = enabled;
}

- (BOOL)enabled {
    return self.inputField.enabled;
}
@end
