//
//  HWMFunctionListCell.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/24.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMFunctionListCell.h"
#import "HWMFunctionModel.h"

@interface HWMFunctionListCell ()
///标题
@property (nonatomic, strong) NSTextField *titleLabel;

@end

@implementation HWMFunctionListCell

- (instancetype)initWithFrame:(NSRect)frameRect {
    if (self = [super initWithFrame:frameRect]) {
        [self setupUI];
        [self addTrackingArea];
    }
    return self;
}

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];
    
    // Drawing code here.
}

- (void)setModel:(HWMFunctionModel *)model {
    _model = model;
    self.titleLabel.stringValue = model.name;
    if (model.selected) {
        self.layer.backgroundColor = [NSColor colorWithRGB:0xECF1F7].CGColor;
    }else {
        self.layer.backgroundColor = [NSColor whiteColor].CGColor;
    }
}

#pragma mark - UI
- (void)setupUI {
    self.wantsLayer = YES;
    self.layer.backgroundColor = [NSColor whiteColor].CGColor;
    
    [self addSubview:self.titleLabel];
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self);
        make.leading.equalTo(self).offset(10);
        make.trailing.equalTo(self).offset(-10);
    }];
    
}

#pragma mark - mouse

- (void)mouseEntered:(NSEvent *)event {
    [super mouseEntered:event];
    if (!self.model.isSelected) {
        self.layer.backgroundColor = [NSColor colorWithRGB:0xF3F5F9].CGColor;
    }
}

- (void)mouseExited:(NSEvent *)event {
    [super mouseExited:event];
    if (!self.model.isSelected) {
        self.layer.backgroundColor = [NSColor whiteColor].CGColor;
    }
}

- (void)mouseDown:(NSEvent *)event {
    [super mouseDown:event];
    if (self.functionClickDownHandler) {
        self.functionClickDownHandler(self.model);
    }
}

#pragma mark - Lazy
- (NSTextField *)titleLabel {
    if (!_titleLabel) {
        _titleLabel = [NSTextField hwm_fieldWithTitle:@"" titleColor:[NSColor colorWithRGB:0x666666] font:[NSFont systemFontOfSize:13]];
    }
    return _titleLabel;
}
@end
