//
//  NSTextField+HWMExtension.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/24.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "NSTextField+HWMExtension.h"

@implementation NSTextField (HWMDemoExtension)

+ (instancetype)hwm_fieldWithTitle:(NSString *)title titleColor:(NSColor *)titleColor font:(NSFont *)font lineSpaceing:(CGFloat)space {
    NSTextField *field = [self hwm_fieldWithTitle:title titleColor:titleColor font:font];
    NSMutableParagraphStyle *style = [[NSMutableParagraphStyle alloc] init];
    style.lineSpacing = space;
    NSString *realTitle = title ? title : @"";
    NSMutableAttributedString *att = [[NSMutableAttributedString alloc] initWithString:realTitle];
    [att addAttributes:@{NSParagraphStyleAttributeName : style} range:NSMakeRange(0, realTitle.length)];
    field.attributedStringValue = att;
    return field;
}

+ (instancetype)hwm_fieldWithTitle:(NSString *)title titleColor:(NSColor *)titleColor font:(NSFont *)font {
    NSTextField *field = [self new];
    field.focusRingType = NSFocusRingTypeNone;
    field.lineBreakMode = NSLineBreakByTruncatingTail;
    [field.cell setTruncatesLastVisibleLine:YES];
    field.cell.usesSingleLineMode = NO;
    field.maximumNumberOfLines = 0;
    field.backgroundColor = [NSColor clearColor];
    field.editable = NO;
    field.bordered = NO;
    field.textColor = titleColor;
    field.font = font;
    if (NSApp.userInterfaceLayoutDirection == NSUserInterfaceLayoutDirectionRightToLeft) {
        field.alignment = NSTextAlignmentRight;
        field.lineBreakMode = NSLineBreakByTruncatingHead;
    }
    if (title) {
        field.stringValue = title;
    }
    return field;
}

@end
