//
//  HWMSdk.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/10/9.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMOpenSDKConfig.h"
#import "HWMOpenApi.h"
#import "HWMUISDKJsonConfigInfo.h"
@class HWMPrivateApi;

NS_ASSUME_NONNULL_BEGIN

@interface HWMSdk : NSObject

/// 初始化SDK
/// - 必须
/// - 在主线程调用该方法
/// - 建议在App启动后调用
/// @param config 配置信息，详见 HWMOpenSDKConfig
/// @return YES 初始化成功 NO 初始化 失败
+ (BOOL)initWithConfig:(HWMOpenSDKConfig *)config;

/// sdk 是否已经初始化
+ (BOOL)hasInit;

/// 获取sdk配置信息
/// - 如果要在运行时动态获取sdk的配置，务必使用该接口获取到对象
/// - 可以在获取到该配置后，修改某些配置信息
+ (HWMOpenSDKConfig *)getSdkConfig;

+ (HWMSDKERR)configWithJson:(NSString *)json;

+ (HWMUISDKJsonConfigInfo *)getJsonConfigInfo;

/// 获取api对象
/// - 调用sdk业务接口，都需要先获取到该Api对象
+ (HWMOpenApi *)getOpenApi;


/// 获取私有Api对象，目前暂不开放，请勿使用，不保证稳定性，后期可能变化
+ (HWMPrivateApi *)getPrivateApi;

/// 设置日志路径
/// - 可选
/// 如果不想指定可以不设置，默认为程序的Application Support/App名  路径
/// @param logPath log path 日志路径，用于自定义日志文件存储的位置
+ (void)setLogPath:(NSString *)logPath;

/// 设置应用语言，不支持在会议中使用
+ (void)setLanguage:(HWMSdkLanguageType)language;

/// 设置应用语言，不支持在会议中使用
/// @param language 语言类型
/// @param languageCode 如果是中文或英文，传空字符串，如果language是自定义语言（请先在资源文件中配置对应文件），传不带后缀的文件名，如：ar.lproj(阿拉伯语)，传ar
+ (void)setLanguage:(HWMSdkLanguageType)language languageCode:(NSString *)languageCode;

/// 更新服务器地址和端口
/// -可选
/// @param url 华为云服务器地址
/// @param port 华为云端口号
+ (void)setServerConfigWithUrl:(NSString *)url port:(NSUInteger)port;

/// 设置网络模式
+ (void)setNetworkModeWithAccessType:(HWMAccessType)accessType API_AVAILABLE(macos(10.13));

/// 退出SDK
+ (void)exit;

@end

NS_ASSUME_NONNULL_END
