//
//  HWMSettingTabItem.h
//  HWMUISDK
//
//  Created by linweiqiang on 2021/12/15.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMSdkDefine.h"

NS_ASSUME_NONNULL_BEGIN

#pragma mark - HWMSettingHotKeyItem

@interface HWMSettingHotKeyItem : NSObject

@property (nonatomic, assign, readonly) HWMSettingHotKeyType type;
@property (nonatomic, assign) NSInteger keyCode;
@property (nonatomic, copy) NSString *keyName;
@property (nonatomic, copy) dispatch_block_t action;
@property (nonatomic, copy) NSString *text;
- (instancetype)initWithType:(HWMSettingHotKeyType)type text:(NSString *)text keyCode:(NSInteger)keyCode keyName:(NSString *)keyName;
+ (HWMSettingHotKeyItem *)defaulOpenMain; // 打开主面板
+ (HWMSettingHotKeyItem *)defaulActivateSearch; // 激活搜索

@end

#pragma mark - HWMSettingMenuItem

@interface HWMSettingMenuItem : NSObject

@property (nonatomic, assign, readonly) HWMSettingMenuType type;
@property (nonatomic, copy) NSString *text;
- (instancetype)initWithType:(HWMSettingMenuType)type text:(NSString *)text;
+ (HWMSettingMenuItem *)defaulMenuLogin; // 默认登录设置
+ (HWMSettingMenuItem *)defaulMenuCall; // 默认会议呼叫设置
+ (HWMSettingMenuItem *)defaulMenuChatNotify; // 默认聊天消息提醒设置
+ (HWMSettingMenuItem *)defaulMenuSubtitle; // 默认字幕设置
+ (HWMSettingMenuItem *)defaultMenuWindowFilter; // 默认会议窗口过滤设置
+ (HWMSettingMenuItem *)defaulMenuMicrophone; // 默认麦克风设置
+ (HWMSettingMenuItem *)defaulMenuSpeaker; // 默认扬声器设置
+ (HWMSettingMenuItem *)defaultMenuAIAudioTnr; //默认智能降噪设置
+ (HWMSettingMenuItem *)defaulMenuAdvanced; // 默认高级设置
+ (HWMSettingMenuItem *)defaulMenuCamera; // 默认摄像头设置
+ (HWMSettingMenuItem *)defaulMenuLayout; // 默认画面设置
+ (HWMSettingMenuItem *)defaulMenuRecord; // 默认录制设置
+ (HWMSettingMenuItem *)defaulMenuLocalRecordSetting; // 默认本地录制设置
+ (HWMSettingMenuItem *)defaulMenuVirtual; // 默认虚拟背景设置
+ (HWMSettingMenuItem *)defaulMenuHotKey; // 默认快捷键设置
+ (HWMSettingMenuItem *)defaulMenuScreen; // 默认屏幕设置

@end

#pragma mark - HWMSettingTabItem

@interface HWMSettingTabItem : NSObject

@property (nonatomic, assign, readonly) HWMSettingTabType type;
@property (nonatomic, copy) NSString *text;
@property (nonatomic, strong) NSImage *image;
@property (nonatomic, strong) NSImage *hoverImage;
@property (nonatomic, strong) NSArray <HWMSettingMenuItem *> *settingMenuItems;
- (instancetype)initWithType:(HWMSettingTabType)type text:(NSString *)text image:(NSImage *)image hoverImage:(NSImage *)hoverImage;
+ (HWMSettingTabItem *)defaulTabNormal; // 默认常规设置
+ (HWMSettingTabItem *)defaulTabVideo; // 默认视频
+ (HWMSettingTabItem *)defaulTabAudio; // 默认音频
+ (HWMSettingTabItem *)defaulTabRecord; // 默认录制
+ (HWMSettingTabItem *)defaulTabVirtual; // 默认虚拟背景
+ (HWMSettingTabItem *)defaulTabHotKey; // 默认快捷键
+ (HWMSettingTabItem *)defaulTabScreen; // 默认屏幕设置

@end

NS_ASSUME_NONNULL_END
