//
//  HWMNavigationItem.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/11/2.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMNavigationItem.h"
#import "HWMNavigationBar.h"

@interface HWMNavigationItem ()
@property (nonatomic, strong, readwrite) NSView *view;
@end

@implementation HWMNavigationItem

+ (instancetype)itemWithCustomView:(nonnull NSView *)view {
    HWMNavigationItem *item = [HWMNavigationItem new];
    item.view = view;
    return item;
}

+ (instancetype)itemWithTitle:(NSString *)title color:(NSColor *)color image:(NSImage *)image target:(id)target action:(SEL)action
{
    HWMNavigationItem *item = [HWMNavigationItem new];

    NSButton *btn = [NSButton buttonWithTitle:title font:[NSFont systemFontOfSize:14] fontColor:[NSColor blackColor] target:target action:action];
    btn.frame = NSMakeRect(0, 0, 0, 20);
    btn.imagePosition = NSImageLeft;
    btn.alignment = NSTextAlignmentRight;
    btn.image = image;
    btn.target = target;
    btn.action = action;
    [btn sizeToFit];

    item.view = btn;
    return item;
}

- (void)setBackTitle:(NSString *)backTitle {
    _backTitle = backTitle;
    HWMNavigationBar *bar = (HWMNavigationBar *)self.view.superview.superview;
    if (![bar isKindOfClass:[HWMNavigationBar class]]) {
        return;
    }
    NSButton *btn = (NSButton *)self.view;
    if (![btn isKindOfClass:[NSButton class]]) {
        return;
    }
    NSMutableAttributedString *att = [[NSMutableAttributedString alloc] initWithString:backTitle];
    NSFont *tmpFont = [NSFont systemFontOfSize:14];
    [att addAttributes:@{NSFontAttributeName : tmpFont, NSForegroundColorAttributeName : [NSColor whiteColor]} range:NSMakeRange(0, backTitle.length)];
    btn.attributedTitle = att;
    [btn sizeToFit];
}

- (void)setBackImage:(NSImage *)backImage {
    _backImage = backImage;
    HWMNavigationBar *bar = (HWMNavigationBar *)self.view.superview.superview;
    if (![bar isKindOfClass:[HWMNavigationBar class]]) {
        return;
    }
    NSButton *btn = (NSButton *)self.view;
    if (![btn isKindOfClass:[NSButton class]]) {
        return;
    }
    btn.image = backImage;
    [btn sizeToFit];
}

@end
