//
//  HWMInputView.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/26.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMInputView.h"

@interface HWMInputView ()<NSTextFieldDelegate>

/// 标题
@property (nonatomic, strong) NSTextField *titleLabel;
/// 背景
@property (nonatomic, strong) NSView *fieldBgView;

@end

@implementation HWMInputView

- (instancetype)initWithFrame:(NSRect)frameRect {
    if (self = [super initWithFrame:frameRect]) {
        self.wantsLayer = YES;
        self.layer.backgroundColor = [NSColor whiteColor].CGColor;
        [self setupUI];
    }
    return self;
}

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];
    
}

#pragma mark - UI
- (void)setupUI {
    [self addSubview:self.titleLabel];
    [self addSubview:self.fieldBgView];
    [self.fieldBgView addSubview:self.textField];
    
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self);
        make.centerY.equalTo(self);
    }];
    
    [self.fieldBgView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.titleLabel.mas_trailing).offset(10);
        make.trailing.equalTo(self);
        make.centerY.equalTo(self);
        make.height.mas_equalTo(30);
    }];
    
    [self.textField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.fieldBgView);
        make.leading.equalTo(self.fieldBgView).offset(5);
        make.trailing.equalTo(self.fieldBgView).offset(-5);
    }];
}

#pragma mark - NSTextFieldDelegate
- (void)controlTextDidChange:(NSNotification *)obj {
    NSTextField *field = obj.object;
    if (field == self.textField) {
        if (self.delegate && [self.delegate respondsToSelector:@selector(textFieldDidChanged:)]) {
            [self.delegate textFieldDidChanged:field];
        }
    }
}

#pragma mark - Setter
- (void)setTitle:(NSString *)title {
    _title = title;
    self.titleLabel.stringValue = title;
}

- (void)setPlaceholder:(NSString *)placeholder {
    _placeholder = placeholder;
    self.textField.placeholderString = placeholder;
}

#pragma mark - Lazy
- (NSTextField *)titleLabel {
    if (!_titleLabel) {
        _titleLabel = [NSTextField hwm_fieldWithTitle:@"" titleColor:[NSColor colorWithRGB:0x666666] font:[NSFont systemFontOfSize:13]];
    }
    return _titleLabel;
}

- (HWMTextField *)textField {
    if (!_textField) {
        _textField = [[HWMTextField alloc] init];
        _textField.delegate = self;
    }
    return _textField;
}

- (NSView *)fieldBgView {
    if (!_fieldBgView) {
        _fieldBgView = [[NSView alloc] init];
        _fieldBgView.wantsLayer = YES;
        _fieldBgView.layer.backgroundColor = [NSColor whiteColor].CGColor;
        _fieldBgView.layer.borderColor = [NSColor colorWithRGB:0xEEEEEE].CGColor;
        _fieldBgView.layer.borderWidth = 1.0;
        _fieldBgView.layer.cornerRadius = 2.0;
        _fieldBgView.layer.masksToBounds = YES;
    }
    return _fieldBgView;
}

@end
