//
//  HWMAddAttendeesController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/12/7.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMAddAttendeesController.h"
#import <HWMUISDK/HWMUISDK.h>
#import "HWMSelectContactViewController.h"
#import "HWMContactInfoModel.h"

@interface HWMAddAttendeesController ()

@property (nonatomic, strong) NSButton *inviteBtn;

@end

@implementation HWMAddAttendeesController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

#pragma mark - UI
- (void)setupUI {
    [self.view addSubview:self.inviteBtn];
    [self.inviteBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.center.equalTo(self.view);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

#pragma mark - Event

- (void)inviteBtnClick {
    if (![HWMSdk hasInit]) {
        [HWMConsoleManager shareInstance].console = @"no init";
        return;
    }

    HWMSelectContactViewController *contact = [[HWMSelectContactViewController alloc] init];
    [contact setSelectAttendeeInfoHandler:^(NSArray *_Nullable attendees) {
        NSMutableArray *arr = @[].mutableCopy;
        for (HWMContactInfoModel *model in attendees) {
            HWMAttendeeInfo *info = [[HWMAttendeeInfo alloc] init];
            info.accountId = model.accountId;
            info.name = model.name;
            info.aliasCN = model.aliasCN;
            info.aliasEN = model.aliasEN;
            info.number = model.number;
            info.thirdUserId = model.thirdUserId;
            info.email = model.email;
            info.mute = model.mute;
            info.role = model.role;
            info.sms = model.sms;
            info.orgId = model.corpId;
            [arr addObject:info];
        }
        [[HWMBizSdk getBizOpenApi] addAttendee:arr callback:^(NSError * _Nullable error, id  _Nullable result) {
            if (error) {
                [HWMConsoleManager shareInstance].error = error;
            } else {
                [HWMConsoleManager shareInstance].console = @"add attendees successfully";
            }
        }];
       
    }];
    [self presentViewControllerAsModalWindow:contact];
}

#pragma mark - Lazy

- (NSButton *)inviteBtn {
    if (!_inviteBtn) {
        _inviteBtn = [NSButton buttonWithTitle:@"添加与会者" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(inviteBtnClick)];
        _inviteBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _inviteBtn.layer.cornerRadius = 4.0;
        _inviteBtn.layer.masksToBounds = YES;
    }
    return _inviteBtn;
}

@end
