//
//  HWMAddContactController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2021/8/26.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMAddContactController.h"
#import "HWMInputViewCell.h"
#import "HWMSDKTableView.h"

@interface HWMAddContactController ()<HWMSDKTableViewDataSourse, HWMSDKTableViewDelegate>

/// tableView
@property (nonatomic, strong) HWMSDKTableView *listView;
/// 按钮
@property (nonatomic, strong) NSButton *addBtn;
/// 标题
@property (nonatomic, copy) NSArray *titlesArr;
/// model
@property (nonatomic, strong) HWMContactInfoModel *infoModel;

@end

@implementation HWMAddContactController
- (void)loadView {
    [super loadView];
    self.view.frame = NSMakeRect(0, 0, 450, 350);
}


- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupData];
    [self setupUI];
}

- (void)viewDidAppear {
    [super viewDidAppear];
    [self createWindow];
}
#pragma mark - Data
- (void)setupData {
    self.infoModel = [[HWMContactInfoModel alloc] init];
    self.titlesArr = @[@"第三方账号id(必填三选一)", 
                       @"手机号(必填三选一)",
                       @"sip号码(必填三选一)",
                       @"昵称(非必填项)",
                       @"中文昵称(非必填项)",
                       @"英文昵称(非必填项)",
                       @"企业id(非必填项)"];
}

#pragma mark - UI
- (void)setupUI {

    self.listView = [[HWMSDKTableView alloc] initTableViewClomuIdentifier:@"joinConf"];
    self.listView.delegate = self;
    self.listView.dataSource = self;
    [self.view addSubview:self.listView];
    [self.listView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.view).offset(15);
        make.top.equalTo(self.view).offset(50);
        make.trailing.equalTo(self.view).offset(-15);
        make.bottom.equalTo(self.view).offset(-100);
    }];

    [self.view addSubview:self.addBtn];
    [self.addBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.bottom.equalTo(self.view).offset(-20);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

- (void)createWindow {
    NSWindow *window = self.view.window;
    window.title = @"添加联系人";
    window.backgroundColor = [NSColor colorWithRGB:0xF3F5F9];
    window.titlebarAppearsTransparent = YES;
    window.styleMask = NSWindowStyleMaskTitled | NSWindowStyleMaskClosable;
    [[window standardWindowButton:NSWindowZoomButton] setHidden:YES];
    [[window standardWindowButton:NSWindowMiniaturizeButton] setHidden:YES];
    NSButton *closeBtn = [window standardWindowButton:NSWindowCloseButton];
    closeBtn.target = self;
    closeBtn.action = @selector(closeBtnClose);
    [window center];
}

#pragma mark - Delegate
- (NSInteger)numberOfRowsInTableView:(NSTableView *)tableView {
    return self.titlesArr.count;
}

- (NSView *)tableView:(NSTableView *)tableView viewForTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row {
 
    HWMInputViewCell *cell = [HWMInputViewCell initInputViewCell:tableView ower:self];
    cell.placeholder = self.titlesArr[row];
    cell.index = row;
    cell.content = @"";
    @weakify(self)
    [cell setInputViewDidEndEditerHandler:^(NSString *_Nonnull content, NSInteger index) {
        @strongify(self)
        if (index == 0) {
            self.infoModel.thirdUserId = content;
        } else if (index == 1) {
            self.infoModel.sms = content;
        } else if (index == 2) {
            self.infoModel.number = content;
        } else if (index == 3) {
            self.infoModel.name = content;
        } else if (index == 4) {
            self.infoModel.aliasCN = content;
        } else if (index == 5) {
            self.infoModel.aliasEN = content;
        } else if (index == 6) {
            self.infoModel.corpId = content;
        }
    }];
    return cell;
}

- (CGFloat)tableView:(NSTableView *)tableView heightOfRow:(NSInteger)row {
    return 40.0;
}

- (void)addContact {
    if (self.infoModel.thirdUserId.length == 0 && self.infoModel.number.length == 0 && self.infoModel.sms.length == 0) {
        [HWMConsoleManager shareInstance].console = @"手机号， sip号，第三方账号id，不能都为空";
        return;
    }
    if (self.infoModel.name.length == 0) {
        self.infoModel.name = @"";
    }
    if (self.addContactHandler) {
        self.addContactHandler(self.infoModel);
    }
    [self.view.window close];
    [NSApp stopModal];
}

- (void)closeBtnClose {
    [self.view.window close];
    [NSApp stopModal];
}
#pragma mark - Lazy
- (NSButton *)addBtn {
    if (!_addBtn) {
        _addBtn = [NSButton buttonWithTitle:@"加入会议" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(addContact)];
        _addBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _addBtn.layer.cornerRadius = 4.0;
        _addBtn.layer.masksToBounds = YES;
    }
    return _addBtn;
}

@end
