//
//  HWMEditeSubCycleConfController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2021/10/22.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMEditeSubCycleConfController.h"
#import "HWMSDKTableView.h"
#import <HWMUISDK/HWMUISDK.h>
#import "HWMInputInfoTitleCell.h"
#import "HWMConfTypeSelectCell.h"
#import "HWMSwitchCell.h"
#import "HWMJoinConfLimitCell.h"
#import "NSViewController+HWMNavigation.h"

@interface HWMEditeSubCycleConfController ()<HWMSDKTableViewDelegate, HWMSDKTableViewDataSourse, HWMInputInfoTitleCellDelegate, HWMConfTypeSelectCellDelegate, HWMSwitchCellDelegate>

/// 列表
@property (nonatomic, strong) HWMSDKTableView *listView;
/// 确定按钮
@property (nonatomic, strong) NSButton *confirmBtn;

@end

@implementation HWMEditeSubCycleConfController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

#pragma mark - UI
- (void)setupUI {
    self.listView = [[HWMSDKTableView alloc] initTableViewClomuIdentifier:@"bookConf"];
    self.listView.delegate = self;
    self.listView.dataSource = self;
    [self.view addSubview:self.listView];

    NSString *title = @"编辑会议";
    self.confirmBtn = [NSButton buttonWithTitle:title font:nil fontColor:[NSColor whiteColor] target:self action:@selector(confirmBtnClick)];
    self.confirmBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
    self.confirmBtn.layer.cornerRadius = 4.0;
    self.confirmBtn.layer.masksToBounds = YES;
    [self.view addSubview:self.confirmBtn];

    [self.confirmBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.bottom.equalTo(self.view).offset(-20);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];

    [self.listView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.and.top.equalTo(self.view).offset(15);
        make.trailing.equalTo(self.view).offset(-15);
        make.bottom.equalTo(self.confirmBtn.mas_top).offset(-15);
    }];
}

#pragma mark - Event
- (void)confirmBtnClick {
    
    if (![HWMSdk hasInit]) {
        [HWMConsoleManager shareInstance].console = @"no init";
        return;
    }
    
    if (self.subDatail.startTimeStamp <= 0) {
        [HWMConsoleManager shareInstance].console = @"请输入开始时间";
        return;
    }
    
    if (self.subDatail.endTimeStamp <= 0) {
        [HWMConsoleManager shareInstance].console = @"请输入结束时间";
        return;
    }
    if (self.subDatail.endTimeStamp <= self.subDatail.startTimeStamp) {
        [HWMConsoleManager shareInstance].console = @"结束时间要大于开始时间";
        return;
    }
    
    
    
    HWMSDKModifySubCycleConfParamModel *subCycleParam = [[HWMSDKModifySubCycleConfParamModel alloc] init];
    subCycleParam.confId = self.confID;
    subCycleParam.subConfID = self.subDatail.subConfID;
    subCycleParam.startTimeStamp = self.subDatail.startTimeStamp;
    subCycleParam.confLen = (self.subDatail.endTime - self.subDatail.startTime)/60;
    subCycleParam.callInRestriction = self.subDatail.callInRestriction;
    subCycleParam.allowGuestStartConf = self.subDatail.allowGuestStartConf;
    subCycleParam.confMediaType = self.subDatail.confMediaType;
    subCycleParam.isAutoRecord = self.subDatail.isAutoRecord;
    subCycleParam.recordAuthType = self.subDatail.recordAuthType;
    
    [[HWMBizSdk getBizOpenApi] editSubCycleConf:subCycleParam callback:^(NSError * _Nullable error, id  _Nullable result) {
        if (error) {
            [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"%@", error.description];
        } else {
            [HWMConsoleManager shareInstance].console = @"edit cycle conf successful";
            [self.customNavigationController popViewControllerAnimated:YES];
        }
    }];
}

#pragma mark - Delegate
- (NSInteger)numberOfRowsInTableView:(NSTableView *)tableView {
    return 6;
}

- (NSView *)tableView:(NSTableView *)tableView viewForTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row {
    if (row < 2) {
        HWMInputInfoTitleCell *cell = [self inputInfoCell:tableView row:row];
        
        return cell;
    } else if (row == 2) {
        HWMConfTypeSelectCell *cell = [HWMConfTypeSelectCell initConfTypeSelectCell:tableView ower:self];
        cell.delegate = self;
        cell.confType = self.subDatail.confMediaType;
        
        return cell;
    } else if (row == 3) {
        HWMJoinConfLimitCell *cell = [HWMJoinConfLimitCell joinConfLimitCell:tableView ower:self];
        cell.menuTitles = @[@"所有人", @"仅企业内人员", @"仅会议邀请人员"];
        cell.currentIndex = self.subDatail.callInRestriction > 0 ? self.subDatail.callInRestriction - 1 : 0;
        @weakify(self)
        [cell setSelectMenuItemHandler:^(NSInteger index, NSString * _Nullable itemTitile) {
            @strongify(self)
            self.subDatail.callInRestriction = index > 0 ? index + 1 : index;
        }];
        return cell;
    } else {
        return [self switchCell:tableView row:row];
    }
    
    return nil;
}

- (CGFloat)tableView:(NSTableView *)tableView heightOfRow:(NSInteger)row {
    return 40.0;
}

/// 可输入cell
- (HWMInputInfoTitleCell *)inputInfoCell:(NSTableView *)tableView row:(NSInteger)row {
    HWMInputInfoTitleCell *cell = [HWMInputInfoTitleCell inputInfoTitleCell:tableView ower:self];
    cell.delegate = self;
    cell.index = row;
    if (row == 0) {
        cell.title = @"开始时间";
        cell.placeholder = @"格式：yyyy-MM-dd HH:mm";
        cell.content = [NSString timeStringFromTimeInterval:self.subDatail.startTimeStamp];
        cell.enabled = YES;
    } else if (row == 1) {
        cell.title = @"结束时间";
        cell.placeholder = @"格式：yyyy-MM-dd HH:mm";
        cell.content = [NSString timeStringFromTimeInterval:self.subDatail.endTimeStamp];
        cell.enabled = YES;
    }
    return cell;
}

/// switch cell
- (HWMSwitchCell *)switchCell:(NSTableView *)tableView row:(NSInteger)row {
    HWMSwitchCell *cell = [HWMSwitchCell initSwitchCell:tableView ower:self];
    cell.index = row;
    cell.delegate = self;
    if (row == 4) {
        cell.title = @"打开会议录制";
        cell.state = self.subDatail.isAutoRecord;
        cell.enabled = YES;
    } else if (row == 5) {
        cell.title = @"允许嘉宾开始会议";
        cell.state = self.subDatail.allowGuestStartConf;
        cell.enabled = YES;
    }
    return cell;
}

- (void)inputInfoCellDidEdite:(NSString *)content index:(NSInteger)index {
    if (index == 0) {
        NSTimeInterval timeStamp = [NSString getTimeStampWithDateString:content];
        if (!isnan(timeStamp)) {
            self.subDatail.startTimeStamp = timeStamp;
        } else {
            self.subDatail.startTimeStamp = 0;
        }
    } else if (index == 1) {
        NSTimeInterval timeStamp = [NSString getTimeStampWithDateString:content];
        if (!isnan(timeStamp)) {
            self.subDatail.endTimeStamp = timeStamp;
        } else {
            self.subDatail.endTimeStamp = 0;
        }
    }
}

- (void)switchStateChanged:(BOOL)state index:(NSInteger)index {
    switch (index) {
       
        case 4:
            self.subDatail.isAutoRecord = state;
            break;
        case 5:
            self.subDatail.allowGuestStartConf = state;
            break;
        
        default:
            break;
    }
}

- (void)selectedConfType:(NSInteger)confType {
    self.subDatail.confMediaType = confType;
}

@end
