//
//  HWMJoinConfByLinkViewController.m
//  HWMUISDKNativeDemo
//
//  Created by linweiqiang on 2024/7/8.
//  Copyright © 2024 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMJoinConfByLinkViewController.h"
#import "HWMSDKTableView.h"
#import "HWMInputViewCell.h"
#import "HWMSwitchCell.h"
#import <HWMUISDK/HWMUISDK.h>

typedef NS_ENUM (NSInteger, HWMJoinConfByLinkCellType) {
    HWMJoinConfByLinkCellTypeSiteUrl = 0,
    HWMJoinConfByLinkCellTypeRandom,
    HWMJoinConfByLinkCellTypeNickname,
    HWMJoinConfByLinkCellTypeAliasCN,
    HWMJoinConfByLinkCellTypeAliasEN,
    HWMJoinConfByLinkCellTypeExtendedField,
    HWMJoinConfByLinkCellTypeMic,
    HWMJoinConfByLinkCellTypeCam,
    HWMJoinConfByLinkCellTypeSpk
};

@interface HWMJoinConfByLinkViewController () <HWMSDKTableViewDataSourse, HWMSDKTableViewDelegate, HWMSwitchCellDelegate>

@property (nonatomic, strong) HWMSDKTableView *listView;
@property (nonatomic, strong) NSButton *joinBtn;
@property (nonatomic, strong) NSArray<NSString *> *titlesArray;

/// 根据链接解析出的服务器地址
@property (nonatomic, copy) NSString *siteUrl;
/// 根据链接解析出的随机数
@property (nonatomic, copy) NSString *random;
/// 昵称
@property (nonatomic, copy) NSString *nickname;
/// 中文昵称
@property (nonatomic, copy) NSString *aliasCN;
/// 英文昵称
@property (nonatomic, copy) NSString *aliasEN;
/// 三方自定义字段
@property (nonatomic, copy) NSString *extendedField;
/// 是否打开麦克风
@property (nonatomic, assign) BOOL isMicOn;
/// 是否打开摄像头
@property (nonatomic, assign) BOOL isCamOn;
/// 是否打开扬声器
@property (nonatomic, assign) BOOL isSpkOn;

@end

@implementation HWMJoinConfByLinkViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupData];
    [self setupUI];
}

#pragma mark - Data

- (void)setupData {
    self.titlesArray = @[@"SiteUrl", @"Random", @"Nickname", @"AliasCN", @"AliasEN", @"extendedField", @"Microphone", @"Camera", @"Speaker"];
    self.isMicOn = YES;
    self.isCamOn = NO;
    self.isSpkOn = YES;
}

#pragma mark - UI

- (void)setupUI {
    self.listView = [[HWMSDKTableView alloc] initTableViewClomuIdentifier:@"joinConfByLink"];
    self.listView.delegate = self;
    self.listView.dataSource = self;
    [self.view addSubview:self.listView];
    [self.listView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.and.top.equalTo(self.view).offset(15);
        make.trailing.equalTo(self.view).offset(-15);
        make.bottom.equalTo(self.view).offset(-100);
    }];

    [self.view addSubview:self.joinBtn];
    [self.joinBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.bottom.equalTo(self.view).offset(-20);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

#pragma mark - HWMSDKTableViewDelegate

- (NSInteger)numberOfRowsInTableView:(NSTableView *)tableView {
    return self.titlesArray.count;
}

- (NSView *)tableView:(NSTableView *)tableView viewForTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row {
    BOOL isInputCell = [self isInputCell:row];
    if (isInputCell) {
        HWMInputViewCell *cell = [HWMInputViewCell initInputViewCell:tableView ower:self];
        cell.placeholder = self.titlesArray[row];
        cell.index = row;
        cell.content = @"";
        @weakify(self)
        [cell setInputViewDidEndEditerHandler:^(NSString *_Nonnull content, NSInteger index) {
            @strongify(self)
            if (index == HWMJoinConfByLinkCellTypeSiteUrl) {
                self.siteUrl = content;
            } else if (index == HWMJoinConfByLinkCellTypeRandom) {
                self.random = content;
            } else if (index == HWMJoinConfByLinkCellTypeNickname) {
                self.nickname = content;
            } else if (index == HWMJoinConfByLinkCellTypeAliasCN) {
                self.aliasCN = content;
            } else if (index == HWMJoinConfByLinkCellTypeAliasEN) {
                self.aliasEN = content;
            } else if (index == HWMJoinConfByLinkCellTypeExtendedField) {
                self.extendedField = content;
            }
        }];
        return cell;
    }
    
    HWMSwitchCell *cell = [HWMSwitchCell initSwitchCell:tableView ower:self];
    cell.title = self.titlesArray[row];
    cell.index = row;
    cell.delegate = self;
    if (row == HWMJoinConfByLinkCellTypeMic) {
        cell.state = self.isMicOn;
    } else if (row == HWMJoinConfByLinkCellTypeCam) {
        cell.state = self.isCamOn;
    } else if (row == HWMJoinConfByLinkCellTypeSpk) {
        cell.state = self.isSpkOn;
    }
    return cell;
}

- (CGFloat)tableView:(NSTableView *)tableView heightOfRow:(NSInteger)row {
    return 40.0;
}

- (void)switchStateChanged:(BOOL)state index:(NSInteger)index {
    if (index == HWMJoinConfByLinkCellTypeMic) {
        self.isMicOn = state;
    } else if (index == HWMJoinConfByLinkCellTypeCam) {
        self.isCamOn = state;
    } else if (index == HWMJoinConfByLinkCellTypeSpk) {
        self.isSpkOn = state;
    }
}

- (BOOL)isInputCell:(HWMJoinConfByLinkCellType)type {
    if (type == HWMJoinConfByLinkCellTypeSiteUrl ||
        type == HWMJoinConfByLinkCellTypeRandom ||
        type == HWMJoinConfByLinkCellTypeNickname ||
        type == HWMJoinConfByLinkCellTypeAliasCN ||
        type == HWMJoinConfByLinkCellTypeAliasEN ||
        type == HWMJoinConfByLinkCellTypeExtendedField) {
        return YES;
    }
    return NO;
}

#pragma mark - Event

- (void)joinConfByLink {
    HWMLinkConfParam *param = [[HWMLinkConfParam alloc] init];
    param.siteUrl = self.siteUrl;
    param.random = self.random;
    param.nickname = self.nickname;
    param.aliasCN = self.aliasCN;
    param.aliasEN = self.aliasEN;
    param.extendedField = self.extendedField;
    param.isMicOn = self.isMicOn;
    param.isCameraOn = self.isCamOn;
    param.isSpkOn = self.isSpkOn;

    [[HWMSdk getPrivateApi] joinConfByLink:param callback:^(NSError * _Nullable error, id  _Nullable result) {
        if (error) {
            [HWMConsoleManager shareInstance].error = error;
        } else {
            [HWMConsoleManager shareInstance].console = @"join conf by link success";
        }
    }];
}

#pragma mark - Lazy

- (NSButton *)joinBtn {
    if (!_joinBtn) {
        _joinBtn = [NSButton buttonWithTitle:@"加入会议" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(joinConfByLink)];
        _joinBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _joinBtn.layer.cornerRadius = 4.0;
        _joinBtn.layer.masksToBounds = YES;
    }
    return _joinBtn;
}

@end
