//
//  HWMSelectVrmViewController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/11/6.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSelectVrmViewController.h"
#import "HWMSelectVmrConfCell.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMSelectVrmViewController ()<NSTableViewDelegate, NSTableViewDataSource>

/// tableView
@property (nonatomic, strong) NSTableView *listView;
/// scrollView
@property (nonatomic, strong) NSScrollView *scrollView;

@property (nonatomic, strong) NSButton *confirmBtn;
/// 选中的下标
@property (nonatomic, assign) NSInteger selectIndex;
/// 选中的model
@property (nonatomic, strong) HWMVmrInfoModel *selectModel;

@end

@implementation HWMSelectVrmViewController

- (void)loadView {
    [super loadView];
    self.view.frame = NSMakeRect(0, 0, 500, 400);
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.selectIndex = -1;
    [self setupUI];
}

- (void)viewDidAppear {
    [super viewDidAppear];
    [self createWindow];
}

#pragma mark - UI
- (void)createWindow {
    NSWindow *window = self.view.window;
    window.backgroundColor = [NSColor colorWithRGB:0xF3F5F9];
    window.titlebarAppearsTransparent = YES;
    window.title = @"选择会议";
    window.styleMask = NSWindowStyleMaskTitled | NSWindowStyleMaskClosable;
    [[window standardWindowButton:NSWindowZoomButton] setHidden:YES];
    [[window standardWindowButton:NSWindowMiniaturizeButton] setHidden:YES];
    [window center];
}

- (void)setupUI {
    [self.view addSubview:self.confirmBtn];
    [self.confirmBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.bottom.equalTo(self.view).offset(-20);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];

    self.scrollView = [[NSScrollView alloc] init];
    [self.scrollView setHasVerticalScroller:YES];
    [self.scrollView setHasHorizontalScroller:NO];
    [self.scrollView setBorderType:NSNoBorder];
    [self.scrollView setDrawsBackground:NO];
    [self.scrollView setAutohidesScrollers:YES];
    [self.scrollView setHorizontalScrollElasticity:NSScrollElasticityNone];
    [self.scrollView setVerticalScrollElasticity:NSScrollElasticityNone];
    [self.view addSubview:self.scrollView];

    self.listView = [[NSTableView alloc] init];
    self.listView.delegate = self;
    self.listView.dataSource = self;
    self.listView.backgroundColor = [NSColor whiteColor];
    self.listView.selectionHighlightStyle = NSTableViewSelectionHighlightStyleNone;
    NSTableHeaderView *headerView = [[NSTableHeaderView alloc] initWithFrame:NSZeroRect];
    self.listView.headerView = headerView;
    NSTableColumn *colmn = [[NSTableColumn alloc] initWithIdentifier:@"vrmConf"];
    [self.listView addTableColumn:colmn];
    self.scrollView.documentView = self.listView;

    [self.scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.view).offset(15);
        make.top.equalTo(self.view).offset(30);
        make.trailing.equalTo(self.view).offset(-15);
        make.bottom.equalTo(self.confirmBtn.mas_top).offset(-15);
    }];
}

- (void)setVmrArr:(NSArray<HWMVmrInfoModel *> *)vmrArr {
    _vmrArr = vmrArr;
    [self.listView reloadData];
}

#pragma mark - Delegate

- (NSInteger)numberOfRowsInTableView:(NSTableView *)tableView {
    return self.vmrArr.count;
}

- (NSView *)tableView:(NSTableView *)tableView viewForTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row {
    if (row < self.vmrArr.count) {
        HWMSelectVmrConfCell *cell = [HWMSelectVmrConfCell initSelectVmrConfCell:tableView ower:self];
        cell.index = row;
        cell.select = self.selectIndex == row ? YES : NO;
        cell.infoModel = self.vmrArr[row];
        @weakify(self)
        [cell setSelectVmrConfHandler:^(NSInteger index) {
            @strongify(self)
            self.selectIndex = index;
            [self.listView reloadData];
            self.selectModel = self.vmrArr[index];
        }];

        return cell;
    }
    return nil;
}

- (CGFloat)tableView:(NSTableView *)tableView heightOfRow:(NSInteger)row {
    return 40;
}

#pragma mark - Eevent
- (void)confirmBtnClick {
    if (self.selectVrmInfoHandler) {
        self.selectVrmInfoHandler(self.selectModel);
    }
    [self.view.window close];
    [NSApp stopModal];
}

#pragma mark - Lazy

- (NSButton *)confirmBtn {
    if (!_confirmBtn) {
        _confirmBtn = [NSButton buttonWithTitle:@"确定" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(confirmBtnClick)];
        _confirmBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _confirmBtn.layer.cornerRadius = 4.0;
        _confirmBtn.layer.masksToBounds = YES;
    }
    return _confirmBtn;
}

@end
