//
//  HWMSettingConfigDataSource.m
//  HWMUISDKNativeDemo
//
//  Created by linweiqiang on 2021/11/19.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSettingConfigDataSource.h"
#import <Carbon/Carbon.h>

@interface HWMSettingConfigDataSource ()

@property (nonatomic, strong) NSArray *tabArr;
@property (nonatomic, strong) NSArray *hotKeyArr;

@end

@implementation HWMSettingConfigDataSource

+ (instancetype)sharedInstance {
    static id instance = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        instance = [[self alloc] init];
    });
    return instance;
}

- (NSArray <HWMSettingTabItem *> *)buildSettingTabItems {
    if (self.itemConfig == HWMSettingItemConfigReceiveInput) {
        return _tabArr;
    } else if (self.itemConfig == HWMSettingItemConfigUseInner) {
        return [self useTab];
    } else {
        return @[];
    }
}

- (NSArray <HWMSettingHotKeyItem *> *)buildSettingHotKeyItems {
    if (self.itemConfig == HWMSettingItemConfigReceiveInput) {
        return _hotKeyArr;
    } else if (self.itemConfig == HWMSettingItemConfigUseInner) {
        return [self useHotKey];
    } else {
        return @[];
    }
}

- (void)setDic:(NSDictionary *)dic {
    _dic = dic;
    _tabArr = [self generateTab];
    _hotKeyArr = [self generateHotKey];
}

- (NSArray *)generateTab {
    NSMutableArray *tabArr = [NSMutableArray arrayWithCapacity:0];
    NSArray *tabs = [self.dic objectForKey:@"defaulTab"];
    for (int i = 0; i < tabs.count; i++) {
        NSDictionary *tabDic = tabs[i];
        NSString *type = [tabDic objectForKey:@"type"];
        NSArray *items = [tabDic objectForKey:@"settingMenuItems"];
        HWMSettingTabItem *tabItem = [self getTabItem:type];
        if (tabItem) {
            NSMutableArray *newMenuItem = [NSMutableArray arrayWithCapacity:0];
            for (int j = 0; j < items.count; j++) {
                NSDictionary *itemDic = items[j];
                NSString *type = [itemDic objectForKey:@"type"];
                HWMSettingMenuItem *menuItem = [self getMenuItem:type];
                if (menuItem) {
                    [newMenuItem addObject:menuItem];
                }
            }
            tabItem.settingMenuItems = newMenuItem;
        }
        if (tabItem.settingMenuItems.count) {
            [tabArr addObject:tabItem];
        }
    }
    return tabArr;
}

- (HWMSettingTabItem *)getTabItem:(NSString *)str {
    if ([str isEqualToString:@"defaulTabNormal"]) {
        return [HWMSettingTabItem defaulTabNormal];
    }
    if ([str isEqualToString:@"defaulTabVideo"]) {
        return [HWMSettingTabItem defaulTabVideo];
    }
    if ([str isEqualToString:@"defaulTabAudio"]) {
        return [HWMSettingTabItem defaulTabAudio];
    }
    if ([str isEqualToString:@"defaulTabRecord"]) {
        return [HWMSettingTabItem defaulTabRecord];
    }
    if ([str isEqualToString:@"defaulTabVirtual"]) {
        return [HWMSettingTabItem defaulTabVirtual];
    }
    if ([str isEqualToString:@"defaulTabHotKey"]) {
        return [HWMSettingTabItem defaulTabHotKey];
    }
    if ([str isEqualToString:@"defaulTabScreen"]) {
        return [HWMSettingTabItem defaulTabScreen];
    }
    return nil;
}

- (HWMSettingMenuItem *)getMenuItem:(NSString *)str {
    if ([str isEqualToString:@"defaulMenuLogin"]) {
        return [HWMSettingMenuItem defaulMenuLogin];
    }
    if ([str isEqualToString:@"defaulMenuCall"]) {
        return [HWMSettingMenuItem defaulMenuCall];
    }
    if ([str isEqualToString:@"defaulMenuChatNotify"]) {
        return [HWMSettingMenuItem defaulMenuChatNotify];
    }
    if ([str isEqualToString:@"defaulMenuSubtitle"]) {
        return [HWMSettingMenuItem defaulMenuSubtitle];
    }
    if ([str isEqualToString:@"defaultMenuWindowFilter"]) {
        return [HWMSettingMenuItem defaultMenuWindowFilter];
    }
    if ([str isEqualToString:@"defaulMenuMicrophone"]) {
        return [HWMSettingMenuItem defaulMenuMicrophone];
    }
    if ([str isEqualToString:@"defaulMenuSpeaker"]) {
        return [HWMSettingMenuItem defaulMenuSpeaker];
    }
    if ([str isEqualToString:@"defaulMenuAdvanced"]) {
        return [HWMSettingMenuItem defaulMenuAdvanced];
    }
    if ([str isEqualToString:@"defaulMenuCamera"]) {
        return [HWMSettingMenuItem defaulMenuCamera];
    }
    if ([str isEqualToString:@"defaulMenuLayout"]) {
        return [HWMSettingMenuItem defaulMenuLayout];
    }
    if ([str isEqualToString:@"defaulMenuRecord"]) {
        return [HWMSettingMenuItem defaulMenuRecord];
    }
    if ([str isEqualToString:@"defaulMenuVirtual"]) {
        return [HWMSettingMenuItem defaulMenuVirtual];
    }
    if ([str isEqualToString:@"defaulMenuHotKey"]) {
        return [HWMSettingMenuItem defaulMenuHotKey];
    }
    if ([str isEqualToString:@"defaulMenuScreen"]) {
        return [HWMSettingMenuItem defaulMenuScreen];
    }
    return nil;
}

- (NSArray *)useTab {
    /*
     HWMSettingTabItem *normalTab = [HWMSettingTabItem defaulTabNormal];
     HWMSettingMenuItem *callItem = [HWMSettingMenuItem defaulMenuCall];
     HWMSettingMenuItem *chatNotifyItem = [HWMSettingMenuItem defaulMenuChatNotify];
     HWMSettingMenuItem *subtitleItem = [HWMSettingMenuItem defaulMenuSubtitle];
     HWMSettingMenuItem *windowFilterItem = [HWMSettingMenuItem defaultMenuWindowFilter];
     normalTab.settingMenuItems = @[callItem, chatNotifyItem, subtitleItem, windowFilterItem];
     */
    HWMSettingTabItem *normalTab = [HWMSettingTabItem defaulTabNormal];
    HWMSettingTabItem *videoTab = [HWMSettingTabItem defaulTabVideo];
    HWMSettingTabItem *audioTab = [HWMSettingTabItem defaulTabAudio];
    HWMSettingTabItem *virtualTab = [HWMSettingTabItem defaulTabVirtual];
    HWMSettingTabItem *screenTab = [HWMSettingTabItem defaulTabScreen];
    HWMSettingTabItem *recordTab = [HWMSettingTabItem defaulTabRecord];
    HWMSettingTabItem *hotKeyTab = [HWMSettingTabItem defaulTabHotKey];
    return @[normalTab, videoTab, audioTab, virtualTab, screenTab, recordTab, hotKeyTab];
}

- (NSArray *)generateHotKey {
    NSMutableArray *hotKeyArr = [NSMutableArray arrayWithCapacity:0];
    NSArray *array = [self.dic objectForKey:@"defaulHotKey"];
    if (array.count) {
        for (int i = 0; i < array.count; i++) {
            NSDictionary *dict = array[i];
            NSString *type = [dict objectForKey:@"type"];
            NSString *text = [dict objectForKey:@"text"];
            NSString *keyName = [dict objectForKey:@"keyName"];
            NSString *keyCode = [dict objectForKey:@"keyCode"];
            NSString *action = [dict objectForKey:@"action"];
            HWMSettingHotKeyItem *item = [[HWMSettingHotKeyItem alloc] initWithType:[type integerValue] text:text keyCode:[keyCode integerValue] keyName:keyName];
            item.action = ^{
                [HWMConsoleManager shareInstance].console = action;
            };
            [hotKeyArr addObject:item];
        }
    }
    return hotKeyArr;
}

- (NSArray *)useHotKey {
    HWMSettingHotKeyItem *item = [[HWMSettingHotKeyItem alloc] initWithType:2 text:@"自定义快捷键" keyCode:kVK_ANSI_C keyName:@"HWMHotKeyCustomKey"];
    item.action = ^{
        [HWMConsoleManager shareInstance].console = @"action";
    };
    return @[item];
}

@end
