//
//  HWMConfDetailCell.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/11/2.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMConfDetailCell.h"

@interface HWMConfDetailCell ()

/// 标题
@property (nonatomic, strong) NSTextField *titleLabel;
/// 内容
@property (nonatomic, strong) NSTextField *contentLabel;

@end

@implementation HWMConfDetailCell

+ (instancetype)confDetailCell:(NSTableView *)tableView ower:(id)ower {
    HWMConfDetailCell *cell = [tableView makeViewWithIdentifier:NSStringFromClass([HWMConfDetailCell class]) owner:ower];
    if (cell == nil) {
        cell = [[HWMConfDetailCell alloc] initWithFrame:NSZeroRect];
    }
    return cell;
}

- (instancetype)initWithFrame:(NSRect)frameRect {
    if (self = [super initWithFrame:frameRect]) {
        self.wantsLayer = YES;
        self.layer.backgroundColor = [NSColor whiteColor].CGColor;
        [self setupUI];
    }
    return self;
}

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];
    
    // Drawing code here.
}

#pragma mark - UI
- (void)setupUI {
    [self addSubview:self.titleLabel];
    [self addSubview:self.contentLabel];
    
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self).offset(15);
        make.centerY.equalTo(self);
        make.width.mas_equalTo(180);
    }];
    
    [self.contentLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.trailing.equalTo(self).offset(15);
        make.leading.equalTo(self.titleLabel.mas_trailing).offset(-10);
        make.centerY.equalTo(self);
    }];
}

- (void)setModel:(HWMConfDetailItemModel *)model {
    _model = model;
    self.titleLabel.stringValue = model.title;
    self.contentLabel.stringValue = model.content;
}

#pragma mark - Lazy

- (NSTextField *)titleLabel {
    if (!_titleLabel) {
        _titleLabel = [NSTextField hwm_fieldWithTitle:@"会议主题" titleColor:[NSColor colorWithRGB:0x999999] font:[NSFont systemFontOfSize:13]];
    }
    return _titleLabel;
}

- (NSTextField *)contentLabel {
    if (!_contentLabel) {
        _contentLabel = [NSTextField hwm_fieldWithTitle:@"GM的云会议" titleColor:[NSColor colorWithRGB:0x333333] font:[NSFont systemFontOfSize:13]];
    }
    return _contentLabel;
}

@end
