//
//  HWMConfListItem.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/29.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMConfListItem.h"
#import <HWMUISDK/HWMVmrInfoModel.h>

@interface HWMConfListItem ()

/// 主题
@property (nonatomic, strong) NSTextField *subLabel;
/// 类型
@property (nonatomic, strong) NSTextField *typeLabel;
/// 时间
@property (nonatomic, strong) NSTextField *timeLabel;
/// 编辑
@property (nonatomic, strong) NSButton *editBtn;

@end

@implementation HWMConfListItem

+ (instancetype)initConfListItem:(NSTableView *)tableView ower:(id)ower {
    HWMConfListItem *item = [tableView makeViewWithIdentifier:NSStringFromClass([HWMConfListItem class]) owner:ower];
    if (item == nil) {
        item = [[HWMConfListItem alloc] initWithFrame:NSZeroRect];
        item.identifier = NSStringFromClass([HWMConfListItem class]);
    }
    return item;
}

- (instancetype)initWithFrame:(NSRect)frameRect {
    if (self = [super initWithFrame:frameRect]) {
        self.wantsLayer = YES;
        self.layer.backgroundColor = [NSColor whiteColor].CGColor;
        [self addTrackingArea];
        [self setupUI];
    }
    return self;
}

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];
    
    // Drawing code here.
}

#pragma mark - UI
- (void)setupUI {
    [self addSubview:self.typeLabel];
    [self addSubview:self.editBtn];
    [self addSubview:self.timeLabel];
    [self addSubview:self.subLabel];
    
    [self.typeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self).offset(15);
        make.centerY.equalTo(self);
        make.width.mas_equalTo(60);
    }];
    
    [self.editBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.trailing.equalTo(self).offset(-15);
        make.centerY.equalTo(self);
        make.width.mas_equalTo(55);
        make.height.mas_equalTo(25);
    }];
    
    [self.timeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.trailing.equalTo(self.editBtn.mas_leading).offset(-5);
        make.width.mas_equalTo(100);
        make.centerY.equalTo(self);
    }];
    
    [self.subLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.typeLabel.mas_trailing).offset(5);
        make.trailing.equalTo(self.timeLabel.mas_leading).offset(-5);
        make.centerY.equalTo(self);
    }];
}

#pragma mark - Setter

- (void)setItemInfo:(HWMConfListItemInfo *)itemInfo {
    _itemInfo = itemInfo;
    self.typeLabel.stringValue = itemInfo.videoConf ? @"视频会议" : @"音频会议";
    self.subLabel.stringValue = itemInfo.confSubject;
    NSString *startTime = [NSString timeStringFromTimeInterval:itemInfo.startTimeStamp format:@"HH:mm"];
    NSString *endTime = [NSString timeStringFromTimeInterval:itemInfo.endTimeStamp format:@"HH:mm"];
    
    self.timeLabel.stringValue = [NSString stringWithFormat:@"%@-%@", startTime, endTime];
}

- (void)setVmrInfo:(HWMVmrInfoModel *)vmrInfo {
    _vmrInfo = vmrInfo;
    NSString *title = @"修改";
    NSMutableAttributedString *att = [[NSMutableAttributedString alloc] initWithString:title];
    NSFont *tmpFont = [NSFont systemFontOfSize:12];
    [att addAttributes:@{NSFontAttributeName : tmpFont, NSForegroundColorAttributeName : [NSColor whiteColor]} range:NSMakeRange(0, title.length)];
    
    self.editBtn.attributedTitle = att;
    if (vmrInfo.type == HWMConfIdPersonal) {
        self.typeLabel.stringValue = @"个人会议";
    }else if (vmrInfo.type == HWMConfIdMeetingRoom) {
        self.typeLabel.stringValue = @"云会议室会议";
    }else if (vmrInfo.type == HWMConfIdRandom) {
        self.typeLabel.stringValue = @"随机会议";
    }
    self.subLabel.stringValue = vmrInfo.name;
    self.timeLabel.stringValue = [NSString stringWithFormat:@"会议ID %@", vmrInfo.confId];
    [self.timeLabel mas_updateConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(120);
    }];
}

#pragma mark - Event
- (void)mouseEntered:(NSEvent *)event {
    [super mouseEntered:event];
    self.layer.backgroundColor = [NSColor colorWithRGB:0xF3F5F9].CGColor;
}

- (void)mouseExited:(NSEvent *)event {
    [super mouseExited:event];
    self.layer.backgroundColor = [NSColor colorWithRGB:0XFFFFFF].CGColor;
}

- (void)editConf {
    if (self.vmrInfo) {
        if (self.vmrListItemClickHandler) {
            self.vmrListItemClickHandler(self.vmrInfo);
        }
    }else {
        if (self.joinConfClickHandler) {
            self.joinConfClickHandler(self.itemInfo);
        }
    }
}

#pragma mark - Lazy
- (NSTextField *)typeLabel {
    if (!_typeLabel) {
        _typeLabel = [NSTextField hwm_fieldWithTitle:@"视频会议" titleColor:[NSColor colorWithRGB:0x0D94FF] font:[NSFont systemFontOfSize:12.0]];
    }
    return _typeLabel;
}

- (NSButton *)editBtn {
    if (!_editBtn) {
        _editBtn = [NSButton buttonWithTitle:@"加入" font:[NSFont systemFontOfSize:12.0] fontColor:[NSColor whiteColor] target:self action:@selector(editConf)];
        _editBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _editBtn.layer.cornerRadius = 4.0;
        _editBtn.layer.masksToBounds = YES;
    }
    return _editBtn;
}

- (NSTextField *)timeLabel {
    if (!_timeLabel) {
        _timeLabel = [NSTextField hwm_fieldWithTitle:@"10:14-11:14" titleColor:[NSColor colorWithRGB:0x666666] font:[NSFont systemFontOfSize:12]];
    }
    return _timeLabel;
}

- (NSTextField *)subLabel {
    if (!_subLabel) {
        _subLabel = [NSTextField hwm_fieldWithTitle:@"会议主题" titleColor:[NSColor colorWithRGB:0x666666] font:[NSFont systemFontOfSize:12]];
        _subLabel.cell.alignment = NSTextAlignmentCenter;
    }
    return _subLabel;
}

@end
