//
//  HWMSelectVmrConfCell.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/11/6.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSelectVmrConfCell.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMSelectVmrConfCell ()

/// 选择
@property (nonatomic, strong) NSButton *selectBtn;
/// 主题
@property (nonatomic, strong) NSTextField *subLabel;
/// 类型
@property (nonatomic, strong) NSTextField *confIDLabel;

@end

@implementation HWMSelectVmrConfCell

+ (instancetype)initSelectVmrConfCell:(NSTableView *)tableView ower:(id)ower {
    HWMSelectVmrConfCell *cell = [tableView makeViewWithIdentifier:NSStringFromClass([HWMSelectVmrConfCell class]) owner:ower];
    if (cell == nil) {
        cell = [[HWMSelectVmrConfCell alloc] initWithFrame:NSZeroRect];
    }
    return cell;
}

- (instancetype)initWithFrame:(NSRect)frameRect {
    if (self = [super initWithFrame:frameRect]) {
        self.wantsLayer = YES;
        self.layer.backgroundColor = [NSColor whiteColor].CGColor;
        [self setupUI];
    }
    return self;
}

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];
    
    // Drawing code here.
}

#pragma mark - UI
- (void)setupUI {
    
    [self addSubview:self.selectBtn];
    [self addSubview:self.confIDLabel];
    [self addSubview:self.subLabel];
    
    [self.selectBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self).offset(15);
        make.centerY.equalTo(self);
        make.width.and.height.mas_equalTo(20);
    }];
    
    [self.confIDLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.trailing.equalTo(self).offset(-15);
        make.centerY.equalTo(self);
        make.width.mas_equalTo(100);
    }];
    
    [self.subLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.selectBtn.mas_trailing).offset(10);
        make.centerY.equalTo(self);
        make.trailing.equalTo(self.confIDLabel.mas_leading).offset(-10);
    }];
}

- (void)setSelect:(BOOL)select {
    _select = select;
    self.selectBtn.state = select ? NSControlStateValueOn : NSControlStateValueOff;
}

- (void)setInfoModel:(HWMVmrInfoModel *)infoModel {
    _infoModel = infoModel;
    self.subLabel.stringValue = infoModel.name.length > 0 ? infoModel.name : @"";
    self.confIDLabel.stringValue = infoModel.confId.length > 0 ? infoModel.confId : @"";
}

#pragma mark - Event
- (void)selectBtnClick:(NSButton *)sender {
    
    if (self.selectVmrConfHandler) {
        self.selectVmrConfHandler(self.index);
    }
}

#pragma mark - Lazy
- (NSButton *)selectBtn {
    if (!_selectBtn) {
        _selectBtn = [[NSButton alloc] init];
        _selectBtn.bordered = NO;
        _selectBtn.bezelStyle = NSBezelStyleRegularSquare;
        _selectBtn.state =  NSControlStateValueOff;
        _selectBtn.title = @"";
        [_selectBtn setButtonType:NSButtonTypeRadio];
        _selectBtn.target = self;
        _selectBtn.action = @selector(selectBtnClick:);
    }
    return _selectBtn;
}

- (NSTextField *)confIDLabel {
    if (!_confIDLabel) {
        _confIDLabel = [NSTextField hwm_fieldWithTitle:@"confID" titleColor:[NSColor colorWithRGB:0x666666] font:[NSFont systemFontOfSize:12]];
    }
    return _confIDLabel;
}

- (NSTextField *)subLabel {
    if (!_subLabel) {
        _subLabel = [NSTextField hwm_fieldWithTitle:@"会议主题" titleColor:[NSColor colorWithRGB:0x666666] font:[NSFont systemFontOfSize:12]];
        _subLabel.cell.alignment = NSTextAlignmentCenter;
    }
    return _subLabel;
}

@end
