//
//  HWMSubCycleConfCountCell.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2021/10/21.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSubCycleConfCountCell.h"

@interface HWMSubCycleConfCountCell ()

/// 标题
@property (nonatomic, strong) NSTextField *titleLabel;
/// 范围
@property (nonatomic, strong) NSButton *arrowBtn;

@end

@implementation HWMSubCycleConfCountCell

+ (instancetype)initSubCycleConfCountCell:(NSTableView *)tableView ower:(id)ower {
    HWMSubCycleConfCountCell *cell = [tableView makeViewWithIdentifier:NSStringFromClass([HWMSubCycleConfCountCell class]) owner:ower];
    if (!cell) {
        cell = [[HWMSubCycleConfCountCell alloc] initWithFrame:NSZeroRect];
        cell.identifier = NSStringFromClass([HWMSubCycleConfCountCell class]);
    }
    return cell;
}

- (instancetype)initWithFrame:(NSRect)frameRect {
    if (self = [super initWithFrame:frameRect]) {
        self.wantsLayer = YES;
        self.layer.backgroundColor = [NSColor whiteColor].CGColor;
        [self setupUI];
        [self addTrackingArea];
    }
    return self;
}

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];
    
    // Drawing code here.
}

#pragma mark - UI
- (void)setupUI {
    [self addSubview:self.titleLabel];
    [self addSubview:self.arrowBtn];

    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self).offset(15);
        make.centerY.equalTo(self);
        make.width.mas_equalTo(100);
    }];

    [self.arrowBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.trailing.equalTo(self).offset(-15);
        make.centerY.equalTo(self);
    }];
}

#pragma mark - Event
- (void)limitBtnClick {
    if (self.subCycleConfSelectHandler) {
        self.subCycleConfSelectHandler();
    }
}

- (void)mouseDown:(NSEvent *)event {
    if (self.subCycleConfSelectHandler) {
        self.subCycleConfSelectHandler();
    }
}

#pragma mark - Setter

- (void)setSubConfCount:(NSInteger)subConfCount {
    _subConfCount = subConfCount;
    [self.arrowBtn setTitle:[NSString stringWithFormat:@"%lu 个", subConfCount]];
}

#pragma mark - Lazy
- (NSTextField *)titleLabel {
    if (!_titleLabel) {
        _titleLabel = [NSTextField hwm_fieldWithTitle:@"周期子会议" titleColor:[NSColor colorWithRGB:0x666666] font:[NSFont systemFontOfSize:13]];
    }
    return _titleLabel;
}

- (NSButton *)arrowBtn {
    if (!_arrowBtn) {
        _arrowBtn = [NSButton buttonWithTitle:@"" font:[NSFont systemFontOfSize:13] fontColor:[NSColor blackColor] target:self action:@selector(limitBtnClick)];
        _arrowBtn.layer.backgroundColor = [NSColor whiteColor].CGColor;
        _arrowBtn.image = [NSImage imageNamed:@"arrow_right"];
        _arrowBtn.imagePosition = NSImageRight;
    }
    return _arrowBtn;
}

@end
