//
//  HWMSubCycleConfListCell.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2021/10/22.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSubCycleConfListCell.h"

@interface HWMSubCycleConfListCell ()

/// 类型
@property (nonatomic, strong) NSTextField *typeLabel;
/// 时间
@property (nonatomic, strong) NSTextField *timeLabel;
/// 编辑
@property (nonatomic, strong) NSButton *editBtn;
/// 取消
@property (nonatomic, strong) NSButton *cancelBtn;
/// model
@property (nonatomic, strong) HWMSDKSubCycleConfParamModel *subParam;


@end

@implementation HWMSubCycleConfListCell

+ (instancetype)initSubCycleConfListCell:(NSTableView *)tableView ower:(id)ower {
    HWMSubCycleConfListCell *cell = [tableView makeViewWithIdentifier:NSStringFromClass([HWMSubCycleConfListCell class]) owner:ower];
    if (!cell) {
        cell = [[HWMSubCycleConfListCell alloc] initWithFrame:NSZeroRect];
        cell.identifier = NSStringFromClass([HWMSubCycleConfListCell class]);
    }
    return cell;
}

- (instancetype)initWithFrame:(NSRect)frameRect {
    if (self = [super initWithFrame:frameRect]) {
        self.wantsLayer = YES;
        self.layer.backgroundColor = [NSColor whiteColor].CGColor;
        [self addTrackingArea];
        [self setupUI];
    }
    return self;
}

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];
    
    // Drawing code here.
}

#pragma mark - UI
- (void)setupUI {
    [self addSubview:self.typeLabel];
    [self addSubview:self.editBtn];
    [self addSubview:self.cancelBtn];
    [self addSubview:self.timeLabel];
    
    [self.typeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self).offset(15);
        make.centerY.equalTo(self);
        make.width.mas_equalTo(60);
    }];
    
    [self.editBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.trailing.equalTo(self).offset(-15);
        make.centerY.equalTo(self);
        make.width.mas_equalTo(55);
        make.height.mas_equalTo(25);
    }];
    
    [self.cancelBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.trailing.equalTo(self.editBtn.mas_leading).offset(-15);
        make.centerY.equalTo(self);
        make.width.mas_equalTo(55);
        make.height.mas_equalTo(25);
    }];
    
    [self.timeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.typeLabel.mas_trailing).offset(10);
        make.centerY.equalTo(self);
    }];
    
}


#pragma mark - Event

- (void)mouseEntered:(NSEvent *)event {
    
    self.layer.backgroundColor = [NSColor colorWithRGB:0xF3F5F9].CGColor;
}

- (void)mouseExited:(NSEvent *)event {
    
    self.layer.backgroundColor = [NSColor colorWithRGB:0XFFFFFF].CGColor;
}

- (void)editConf {
    if (self.editSubCycleConfHandler) {
        self.editSubCycleConfHandler(self.subParam);
    }
}

- (void)cancelConf {
    if (self.cancelSubCycleConfHandler) {
        self.cancelSubCycleConfHandler(self.subParam);
    }
}

- (void)bindData:(HWMSDKSubCycleConfParamModel *)subConf {
    self.subParam = subConf;
    self.typeLabel.stringValue = subConf.confMediaType == HWMConfMediaTypeVideo ? @"视频会议" : @"音频会议";
    NSString *startTime = [NSString timeStringFromTimeInterval:subConf.startTimeStamp format:@"yyyy-MM-dd HH:mm"];
    NSString *endTime = [NSString timeStringFromTimeInterval:subConf.endTimeStamp format:@"yyyy-MM-dd HH:mm"];

    self.timeLabel.stringValue = [NSString stringWithFormat:@"%@ - %@", startTime, endTime];
}

#pragma mark - Lazy
- (NSTextField *)typeLabel {
    if (!_typeLabel) {
        _typeLabel = [NSTextField hwm_fieldWithTitle:@"" titleColor:[NSColor colorWithRGB:0x0D94FF] font:[NSFont systemFontOfSize:12.0]];
    }
    return _typeLabel;
}

- (NSButton *)editBtn {
    if (!_editBtn) {
        _editBtn = [NSButton buttonWithTitle:@"编辑" font:[NSFont systemFontOfSize:12.0] fontColor:[NSColor whiteColor] target:self action:@selector(editConf)];
        _editBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _editBtn.layer.cornerRadius = 4.0;
        _editBtn.layer.masksToBounds = YES;
    }
    return _editBtn;
}

- (NSButton *)cancelBtn {
    if (!_cancelBtn) {
        _cancelBtn = [NSButton buttonWithTitle:@"取消" font:[NSFont systemFontOfSize:12.0] fontColor:[NSColor whiteColor] target:self action:@selector(cancelConf)];
        _cancelBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _cancelBtn.layer.cornerRadius = 4.0;
        _cancelBtn.layer.masksToBounds = YES;
    }
    return _cancelBtn;
}

- (NSTextField *)timeLabel {
    if (!_timeLabel) {
        _timeLabel = [NSTextField hwm_fieldWithTitle:@"" titleColor:[NSColor colorWithRGB:0x666666] font:[NSFont systemFontOfSize:12]];
    }
    return _timeLabel;
}

@end
