//
//  HWMConfigServerController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2021/2/19.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMConfigServerController.h"
#import "HWMInputView.h"
#import <HWMUISDK/HWMUISDK.h>
#import "NSViewController+HWMNavigation.h"

@interface HWMConfigServerController ()
/// 服务器地址
@property (nonatomic, strong) HWMInputView *serverView;
/// 端口号
@property (nonatomic, strong) HWMInputView *portView;

@property (nonatomic, strong) NSButton *confirmBtn;

@end

@implementation HWMConfigServerController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

#pragma mark - UI
- (void)setupUI {
    [self.view addSubview:self.serverView];
    [self.view addSubview:self.portView];
    [self.view addSubview:self.confirmBtn];

    [self.serverView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(100);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(300);
    }];
    
    [self.portView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.serverView.mas_bottom).offset(10);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(300);
    }];
    
    [self.confirmBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.top.equalTo(self.portView.mas_bottom).offset(60);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
    
}

#pragma mark - Event

- (void)confirmBtnClick {
    
    NSString *server = self.serverView.textField.stringValue;
    NSString *port = self.portView.textField.stringValue;
    if (server.length == 0) {
        [HWMConsoleManager shareInstance].console = @"please enter server address.";
        return;
    }
    
    if (port.length == 0) {
        [HWMConsoleManager shareInstance].console = @"please enter server port.";
        return;
    }
    
    [HWMSdk setServerConfigWithUrl:server port:port.integerValue];
    
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(1 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [self.customNavigationController popViewControllerAnimated:YES];
    });
}

#pragma mark - Lazy

- (HWMInputView *)serverView {
    if (!_serverView) {
        _serverView = [[HWMInputView alloc] init];
        _serverView.title = @"服务器地址:";
        _serverView.placeholder = @"请输入服务器地址";
    }
    return _serverView;
}

- (HWMInputView *)portView {
    if (!_portView) {
        _portView = [[HWMInputView alloc] init];
        _portView.title = @"端口号:       ";
        _portView.placeholder = @"请输入端口号";
    }
    return _portView;
}

- (NSButton *)confirmBtn {
    if (!_confirmBtn) {
        _confirmBtn = [NSButton buttonWithTitle:@"确定" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(confirmBtnClick)];
        _confirmBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _confirmBtn.layer.cornerRadius = 4.0;
        _confirmBtn.layer.masksToBounds = YES;
    }
    return _confirmBtn;
}
@end
