//
//  HWMSetCAVerifyController.m
//  HWMUISDKNativeDemo
//
//  Created by linweiqiang on 2024/7/1.
//  Copyright © 2024 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMSetCAVerifyController.h"
#import "HWMInputView.h"
#import "HWMSwitchCell.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMSetCAVerifyController () <HWMSwitchCellDelegate>

/// CA证书开关
@property (nonatomic, strong) HWMSwitchCell *CASwitchCell;
/// CA证书路径
@property (nonatomic, strong) HWMInputView *CAPathInputView;

@property (nonatomic, strong) NSButton *confirmBtn;

@property (nonatomic, assign) BOOL CASwitchState;

@end

@implementation HWMSetCAVerifyController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

#pragma mark - Event

- (void)confirmBtnClick {
    [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"%s",__func__];
    HWMUISDKCAVerifyInfoModel *model = [[HWMUISDKCAVerifyInfoModel alloc] init];
    model.verifyMode = self.CASwitchState ? HWMUISDKVerifyModeServer: HWMUISDKVerifyModeNone;
    model.certPath = self.CAPathInputView.textField.stringValue;
    HWMSDKERR result = [[HWMSdk getOpenApi] setCAVerifyInfo:model];
    [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"set CA verify info result: %ld", result];
}

#pragma mark - UI

- (void)setupUI {
    [self.view addSubview:self.CASwitchCell];
    [self.CASwitchCell mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(100);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(640);
    }];
    
    [self.view addSubview:self.CAPathInputView];
    [self.CAPathInputView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.CASwitchCell.mas_bottom).offset(20);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(400);
    }];
    
    [self.view addSubview:self.confirmBtn];
    [self.confirmBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.top.equalTo(self.CAPathInputView.mas_bottom).offset(60);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

#pragma mark - HWMSwitchCellDelegate

- (void)switchStateChanged:(BOOL)state index:(NSInteger)index {
    self.CASwitchState = state;
}

#pragma mark - Lazy

- (HWMSwitchCell *)CASwitchCell {
    if (!_CASwitchCell) {
        _CASwitchCell = [[HWMSwitchCell alloc] init];
        _CASwitchCell.title = @"CA证书开关";
        _CASwitchCell.delegate = self;
        _CASwitchCell.state = self.CASwitchState;
    }
    return _CASwitchCell;
}

- (HWMInputView *)CAPathInputView {
    if (!_CAPathInputView) {
        _CAPathInputView = [[HWMInputView alloc] init];
        _CAPathInputView.title = @"CA证书路径";
        _CAPathInputView.placeholder = @"";
    }
    return _CAPathInputView;
}

- (NSButton *)confirmBtn {
    if (!_confirmBtn) {
        _confirmBtn = [NSButton buttonWithTitle:@"确定" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(confirmBtnClick)];
        _confirmBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _confirmBtn.layer.cornerRadius = 4.0;
        _confirmBtn.layer.masksToBounds = YES;
    }
    return _confirmBtn;
}

@end
