//
//  SDKEnvConfig.m
//  HWMUISDKNativeDemo
//
//  Created by 204053 on 2023/8/3.
//  Copyright © 2023 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "SDKEnvConfig.h"

@implementation SDKEnvConfig

+ (instancetype)sharedInstance
{
    static SDKEnvConfig *instance = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        instance = [[self alloc] init];
    });
    return instance;
}

- (void)setLogPath:(NSString *)logPath {
    if (logPath && logPath.length > 0) {
        [[NSUserDefaults standardUserDefaults] setObject:logPath forKey:@"logPath"];
    } else {
        NSLog(@"logPath is nil or empty string");
    }
}

- (NSString *)logPath {
     // 按天
//     NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
//     formatter.dateFormat = @"YYYYMMdd";
//     NSDate *today = [NSDate date];
//     NSString *logPath = [formatter stringFromDate:today];
//     logPath = [self.sandBoxDataPath stringByAppendingPathComponent:logPath];
    
    // 或配置文件
    return [[NSUserDefaults standardUserDefaults] objectForKey:@"logPath"];
}

- (NSString *)sandBoxDataPath
{
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSApplicationSupportDirectory, NSUserDomainMask, YES);
    NSString *applicationDir = [paths objectAtIndex:0];
    NSString *bundleName = [[[NSBundle mainBundle] infoDictionary] objectForKey:(NSString *)kCFBundleNameKey];
    applicationDir = [applicationDir stringByAppendingPathComponent:bundleName];

    return applicationDir;
}

@end
