//
//  HWMLoginOutController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/28.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMLoginOutController.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMLoginOutController ()

@end

@implementation HWMLoginOutController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    NSButton *loginOutBtn = [NSButton buttonWithTitle:@"登出" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(loginOut)];
    loginOutBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
    loginOutBtn.layer.cornerRadius = 4.0;
    loginOutBtn.layer.masksToBounds = YES;
    
    [self.view addSubview:loginOutBtn];
    
    [loginOutBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.center.equalTo(self.view);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

- (void)loginOut {
    
    [[HWMSdk getOpenApi] logout:^(NSError * _Nullable error, HWMLogoutResult * _Nullable result) {
        if (error) {
            [HWMConsoleManager shareInstance].error = error;
        }else {
            [HWMConsoleManager shareInstance].console = @"log out successful";
            [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"log out result: %@", result.description];
            [[NSUserDefaults standardUserDefaults] setBool:NO forKey:@"login"];
            [[NSUserDefaults standardUserDefaults] synchronize];
        }
    }];
    
}

@end
