//
//  HWMAppIdLoginModel.h
//  HWMUISDKNativeDemo
//
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface HWMAppIdLoginModel : NSObject

/// (必填)申请到的appId
@property (nonatomic, copy) NSString *appId;

/// (必填)signature
@property (nonatomic, copy) NSString *signature;

/// (必填)用户的账号。1~64位
@property (nonatomic, copy) NSString *thirdUserId;

/// (必填)signature 过期时间。单位为秒的时间戳，为0时表示不会过期
@property (nonatomic, assign) NSUInteger expireTime;

/// (必填)随机字符串。32~64位
@property (nonatomic, copy) NSString *nonce;

/// (必填)用户名
@property (nonatomic, copy) NSString *userName;

/// (选填，无默认值)邮箱。会校验邮箱格式合法性
@property (nonatomic, copy) NSString *userEmail;

/// (选填，无默认值)手机号,不校验手机格式。0~32位
@property (nonatomic, copy) NSString *userPhone;

/// (选填, SP鉴权需要)企业ID
@property (nonatomic, copy) NSString *corpId;

/// (选填)部门编码
@property (nonatomic, copy) NSString *deptCode;
@end

NS_ASSUME_NONNULL_END
